/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.lib.HsqlDateTime;

class BinaryServerRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    public BinaryServerRowInput(byte[] byArray) throws IOException {
        super(byArray, -1);
    }

    public BinaryServerRowInput(byte[] byArray, int n) throws IOException {
        super(byArray, n);
    }

    byte[] readByteArray() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    public int readType() throws IOException {
        return this.readShort();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public String readString() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return new String(byArray, "utf-8");
    }

    protected boolean checkNull() throws IOException {
        byte by = this.readByte();
        return by == 0;
    }

    protected String readChar(int n) throws IOException {
        return this.readString();
    }

    protected Integer readSmallint() throws IOException, SQLException {
        return new Integer(this.readShort());
    }

    protected Integer readInteger() throws IOException, SQLException {
        return new Integer(this.readInt());
    }

    protected Long readBigint() throws IOException, SQLException {
        return new Long(this.readLong());
    }

    protected Double readReal(int n) throws IOException, SQLException {
        return new Double(Double.longBitsToDouble(this.readLong()));
    }

    protected BigDecimal readDecimal() throws IOException, SQLException {
        byte[] byArray = this.readByteArray();
        int n = this.readInt();
        BigInteger bigInteger = new BigInteger(byArray);
        return new BigDecimal(bigInteger, n);
    }

    protected Boolean readBit() throws IOException, SQLException {
        return new Boolean(this.readBoolean());
    }

    protected Time readTime() throws IOException, SQLException {
        return new Time(this.readLong());
    }

    protected Date readDate() throws IOException, SQLException {
        return new Date(this.readLong());
    }

    protected Timestamp readTimestamp() throws IOException, SQLException {
        return HsqlDateTime.timestampValue(this.readLong(), this.readInt());
    }

    protected Object readOther() throws IOException, SQLException {
        byte[] byArray = this.readByteArray();
        return ByteArray.deserialize(byArray);
    }

    protected byte[] readBinary(int n) throws IOException, SQLException {
        return this.readByteArray();
    }
}

