/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.StringConverter;

class HsqlName {
    String name;
    boolean isNameQuoted;
    String statementName;
    static int sysNumber = 0;

    public HsqlName(String string, boolean bl) {
        this.rename(string, bl);
    }

    public HsqlName(String string, String string2, boolean bl) {
        this.rename(string, string2, bl);
    }

    public static HsqlName makeAutoName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SYS_");
        stringBuffer.append(string);
        stringBuffer.append('_');
        stringBuffer.append(++sysNumber);
        return new HsqlName(stringBuffer.toString(), false);
    }

    public static HsqlName makeAutoName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SYS_");
        stringBuffer.append(string);
        stringBuffer.append('_');
        stringBuffer.append(string2);
        stringBuffer.append('_');
        stringBuffer.append(++sysNumber);
        return new HsqlName(stringBuffer.toString(), false);
    }

    public void rename(String string, boolean bl) {
        this.name = string;
        this.statementName = string;
        this.isNameQuoted = bl;
        if (string == null) {
            return;
        }
        if (this.isNameQuoted) {
            this.statementName = StringConverter.toQuotedString(string, '\"', true);
        }
        if (string.startsWith("SYS_")) {
            int n = string.lastIndexOf(95) + 1;
            try {
                int n2 = Integer.parseInt(string.substring(n));
                if (n2 > sysNumber) {
                    sysNumber = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void rename(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('_');
        stringBuffer.append(string2);
        this.rename(stringBuffer.toString(), bl);
    }

    public boolean equals(HsqlName hsqlName) {
        return this.name.equals(hsqlName.name) && this.isNameQuoted == hsqlName.isNameQuoted;
    }

    public static boolean isReservedName(String string) {
        return string.startsWith("SYS_IDX_") || string.startsWith("SYS_PK_") || string.startsWith("SYS_REF_");
    }

    public boolean isReservedName() {
        return HsqlName.isReservedName(this.name);
    }
}

