/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;

final class CompoundFileWriter {
    private Directory directory;
    private String fileName;
    private HashSet ids;
    private LinkedList entries;
    private boolean merged = false;

    public CompoundFileWriter(Directory dir, String name) {
        if (dir == null) {
            throw new IllegalArgumentException("Missing directory");
        }
        if (name == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.directory = dir;
        this.fileName = name;
        this.ids = new HashSet();
        this.entries = new LinkedList();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public void addFile(String file) {
        if (this.merged) {
            throw new IllegalStateException("Can't add extensions after merge has been called");
        }
        if (file == null) {
            throw new IllegalArgumentException("Missing source file");
        }
        if (!this.ids.add(file)) {
            throw new IllegalArgumentException("File " + file + " already added");
        }
        FileEntry entry = new FileEntry();
        entry.file = file;
        this.entries.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        if (this.merged) {
            throw new IllegalStateException("Merge already performed");
        }
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("No entries to merge have been defined");
        }
        this.merged = true;
        OutputStream os = null;
        try {
            FileEntry fe;
            os = this.directory.createFile(this.fileName);
            os.writeVInt(this.entries.size());
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                FileEntry fe2 = (FileEntry)it.next();
                fe2.directoryOffset = os.getFilePointer();
                os.writeLong(0L);
                os.writeString(fe2.file);
            }
            byte[] buffer = new byte[1024];
            it = this.entries.iterator();
            while (it.hasNext()) {
                fe = (FileEntry)it.next();
                fe.dataOffset = os.getFilePointer();
                this.copyFile(fe, os, buffer);
            }
            it = this.entries.iterator();
            while (it.hasNext()) {
                fe = (FileEntry)it.next();
                os.seek(fe.directoryOffset);
                os.writeLong(fe.dataOffset);
            }
            OutputStream tmp = os;
            os = null;
            tmp.close();
            Object var6_5 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            os.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(FileEntry source, OutputStream os, byte[] buffer) throws IOException {
        InputStream is = null;
        try {
            long length;
            long startPtr = os.getFilePointer();
            is = this.directory.openFile(source.file);
            long remainder = length = is.length();
            int chunk = buffer.length;
            while (remainder > 0L) {
                int len = (int)Math.min((long)chunk, remainder);
                is.readBytes(buffer, 0, len);
                os.writeBytes(buffer, len);
                remainder -= (long)len;
            }
            if (remainder != 0L) {
                throw new IOException("Non-zero remainder length after copying: " + remainder + " (id: " + source.file + ", length: " + length + ", buffer size: " + chunk + ")");
            }
            long endPtr = os.getFilePointer();
            long diff = endPtr - startPtr;
            if (diff != length) {
                throw new IOException("Difference in the output file offsets " + diff + " does not match the original file length " + length);
            }
            Object var17_12 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var17_13 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
    }

    private static final class FileEntry {
        String file;
        long directoryOffset;
        long dataOffset;

        private FileEntry() {
        }
    }
}

