/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.prettywriter;

import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.DAML;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.Unparser;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class PrettyWriter
implements RDFWriter,
RDFErrorHandler {
    private static RDFDefaultErrorHandler defaultErrorHandler = new RDFDefaultErrorHandler();
    private RDFErrorHandler errorHandler = defaultErrorHandler;
    private Map nameSpacePrefices = new HashMap();
    private Resource[] types = new Resource[]{DAML.Ontology, DAML.Class, DAML.Datatype, DAML.Property, DAML.ObjectProperty, DAML.DatatypeProperty, DAML.TransitiveProperty, DAML.UnambigousProperty, DAML.UniqueProperty};

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        if (rDFErrorHandler2 == defaultErrorHandler) {
            rDFErrorHandler2 = null;
        }
        this.errorHandler = rDFErrorHandler == null ? defaultErrorHandler : rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public void setNsPrefix(String string, String string2) {
        this.nameSpacePrefices.put(string, string2);
    }

    public Object setProperty(String string, Object object) throws RDFException {
        if (string.equalsIgnoreCase("prettyTypes")) {
            Resource[] resourceArray = this.types;
            this.types = (Resource[])object;
            return resourceArray;
        }
        throw new RDFException(22);
    }

    public void write(Model model, Writer writer, String string) throws RDFException {
        PrintWriter printWriter = new PrintWriter(writer);
        Unparser unparser = new Unparser(this, string, model, printWriter);
        unparser.setTopLevelTypes(this.types);
        unparser.useNameSpaceDecl(this.nameSpacePrefices);
        unparser.write();
        printWriter.flush();
    }

    public void error(Exception exception) {
        this.errorHandler.error(exception);
    }

    public void warning(Exception exception) {
        this.errorHandler.warning(exception);
    }

    public void fatalError(Exception exception) {
        this.errorHandler.fatalError(exception);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Test code for bug 77");
        ModelMem modelMem = new ModelMem();
        modelMem.read(new FileReader("modules/rdf/regression/arp/bug51_0.rdf"), "http://example.org/file");
        RDFWriter rDFWriter = modelMem.getWriter("RDF/XML-ABBREV");
        rDFWriter.setNsPrefix("eg", "http://example.org/");
        rDFWriter.setNsPrefix("eg2", "http://example.org/foo#");
        rDFWriter.write(modelMem, new OutputStreamWriter(System.out), "http://example.org/file");
    }
}

