/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.CachedProfile;
import com.hp.hpl.deli.Profile;
import com.hp.hpl.deli.Workspace;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class ProfileCache {
    private Map cache;
    private Workspace workspace;

    protected ProfileCache(Workspace workspace) {
        this.workspace = workspace;
        this.cache = new HashMap(this.workspace.maxCacheSize * 2);
    }

    protected Profile get(String string) throws Exception {
        CachedProfile cachedProfile;
        this.workspace.printDebug("ProfileCache: Retrieving profile");
        if (this.cache.containsKey(string)) {
            this.workspace.printDebug("ProfileCache: Retrieving cached profile");
            cachedProfile = (CachedProfile)this.cache.get(string);
        } else {
            boolean bl;
            if (this.cache.size() > this.workspace.maxCacheSize) {
                ProfileCache profileCache = this;
                synchronized (profileCache) {
                    int n = new Random().nextInt(this.workspace.maxCacheSize);
                    Object[] objectArray = this.cache.values().toArray();
                    this.cache.remove((String)objectArray[n]);
                }
            }
            if (!(bl = (cachedProfile = new CachedProfile()).set(this.workspace, string))) {
                this.workspace.printDebug("ProfileCache: Unable to retrieve the profile");
                return null;
            }
            ProfileCache profileCache = this;
            synchronized (profileCache) {
                this.cache.put(string, cachedProfile);
            }
        }
        return cachedProfile.get();
    }
}

