/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import java.util.Map;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CloningInheritableThreadLocal;
import org.apache.cocoon.components.EnvironmentDescription;
import org.apache.cocoon.components.EnvironmentStack;
import org.apache.cocoon.components.RequestLifecycleComponent;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.SourceResolver;

public final class CocoonComponentManager
extends ExcaliburComponentManager {
    private static final String PROCESS_KEY = "org.apache.cocoon.components.CocoonComponentManager";
    private static InheritableThreadLocal environmentStack = new CloningInheritableThreadLocal();

    public CocoonComponentManager() {
        super(null, Thread.currentThread().getContextClassLoader());
    }

    public CocoonComponentManager(ClassLoader loader) {
        super(null, loader);
    }

    public CocoonComponentManager(ComponentManager manager, ClassLoader loader) {
        super(manager, loader);
    }

    public CocoonComponentManager(ComponentManager manager) {
        super(manager);
    }

    public static void enterEnvironment(Environment env, Map objectModel, Processor processor) {
        if (environmentStack.get() == null) {
            environmentStack.set(new EnvironmentStack());
        }
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        stack.push(new Object[]{env, processor});
        EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
        if (null != desc) {
            // empty if block
        }
    }

    public static void leaveEnvironment() {
        Object[] objects;
        EnvironmentDescription desc;
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null == stack || stack.empty() || null != (desc = (EnvironmentDescription)((Environment)(objects = (Object[])stack.pop())[0]).getObjectModel().get(PROCESS_KEY))) {
            // empty if block
        }
    }

    public static Object startProcessing(Environment env) {
        EnvironmentDescription desc = new EnvironmentDescription(env);
        env.getObjectModel().put(PROCESS_KEY, desc);
        return desc;
    }

    public static void endProcessing(Environment env, Object key) {
        EnvironmentDescription desc = (EnvironmentDescription)key;
        desc.release();
        env.getObjectModel().remove(PROCESS_KEY);
    }

    public static Environment getCurrentEnvironment() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            return (Environment)((Object[])stack.getCurrent())[0];
        }
        return null;
    }

    public static Processor getCurrentProcessor() {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            return (Processor)((Object[])stack.getCurrent())[1];
        }
        return null;
    }

    public static EnvironmentStack getCurrentEnvironmentStack() {
        return (EnvironmentStack)environmentStack.get();
    }

    public Component lookup(String role) throws ComponentException {
        Component component;
        Object[] objects;
        Map objectModel;
        EnvironmentDescription desc;
        if (null == role) {
            String message = "ComponentLocator Attempted to retrieve component with null role.";
            throw new ComponentException(role, "ComponentLocator Attempted to retrieve component with null role.");
        }
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty() && null != (desc = (EnvironmentDescription)(objectModel = ((Environment)(objects = (Object[])stack.getCurrent())[0]).getObjectModel()).get(PROCESS_KEY)) && null != (component = desc.getRequestLifecycleComponent(role))) {
            return component;
        }
        Component component2 = super.lookup(role);
        if (null != component2 && component2 instanceof RequestLifecycleComponent) {
            if (stack == null || stack.empty()) {
                throw new ComponentException(role, "ComponentManager has no Environment Stack.");
            }
            Object[] objects2 = (Object[])stack.getCurrent();
            Map objectModel2 = ((Environment)objects2[0]).getObjectModel();
            EnvironmentDescription desc2 = (EnvironmentDescription)objectModel2.get(PROCESS_KEY);
            if (null != desc2 && !desc2.containsRequestLifecycleComponent(role)) {
                try {
                    if (component2 instanceof Recomposable) {
                        ((Recomposable)component2).recompose((ComponentManager)this);
                    }
                    ((RequestLifecycleComponent)component2).setup((SourceResolver)objects2[0], objectModel2);
                }
                catch (Exception local) {
                    throw new ComponentException(role, "Exception during setup of RequestLifecycleComponent.", (Throwable)local);
                }
                desc2.addRequestLifecycleComponent(role, component2, (ComponentManager)this);
            }
        }
        return component2;
    }

    public void release(Component component) {
        if (null == component) {
            return;
        }
        if (component instanceof RequestLifecycleComponent) {
            return;
        }
        super.release(component);
    }

    public static void addComponentForAutomaticRelease(ComponentSelector selector, Component component, ComponentManager manager) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            Object[] objects = (Object[])stack.get(0);
            Map objectModel = ((Environment)objects[0]).getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.addToAutoRelease(selector, component, manager);
            }
        } else {
            throw new ProcessingException("Unable to add component for automatic release: no environment available.");
        }
    }

    public static void addComponentForAutomaticRelease(ComponentManager manager, Component component) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            Object[] objects = (Object[])stack.get(0);
            Map objectModel = ((Environment)objects[0]).getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.addToAutoRelease(manager, component);
            }
        } else {
            throw new ProcessingException("Unable to add component for automatic release: no environment available.");
        }
    }

    public static void removeFromAutomaticRelease(Component component) throws ProcessingException {
        EnvironmentStack stack = (EnvironmentStack)environmentStack.get();
        if (null != stack && !stack.empty()) {
            Object[] objects = (Object[])stack.get(0);
            Map objectModel = ((Environment)objects[0]).getObjectModel();
            EnvironmentDescription desc = (EnvironmentDescription)objectModel.get(PROCESS_KEY);
            if (null != desc) {
                desc.removeFromAutoRelease(component);
            }
        } else {
            throw new ProcessingException("Unable to remove component from automatic release: no environment available.");
        }
    }
}

