/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.POIFSElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Cell;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Sheet;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Workbook;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public abstract class BaseElementProcessor
extends AbstractLoggable
implements POIFSElementProcessor {
    private Map _attributes = new HashMap();
    private POIFSFileSystem _filesystem = null;
    private BaseElementProcessor _parent = null;
    private StringBuffer _data = new StringBuffer();

    protected BaseElementProcessor(Attribute[] implied_attributes) {
        if (implied_attributes != null) {
            int k = 0;
            while (k < implied_attributes.length) {
                this._attributes.put(implied_attributes[k].getName(), implied_attributes[k]);
                ++k;
            }
        }
    }

    protected Iterator getAttributes() {
        return this._attributes.values().iterator();
    }

    protected String getValue(String name) {
        String value = null;
        Attribute attr = (Attribute)this._attributes.get(name);
        if (attr != null) {
            value = attr.getValue();
        }
        return value;
    }

    protected POIFSFileSystem getFilesystem() {
        return this._filesystem;
    }

    protected ElementProcessor getParent() {
        return this._parent;
    }

    protected ElementProcessor getAncestor(Class theclass) {
        ElementProcessor parent = this.getParent();
        if (parent == null || parent.getClass().equals(theclass)) {
            return parent;
        }
        return ((BaseElementProcessor)parent).getAncestor(theclass);
    }

    protected String getData() {
        return this._data.toString().trim();
    }

    protected Workbook getWorkbook() throws IOException {
        if (this._parent == null) {
            throw new IOException("Cannot find the workbook object");
        }
        return this._parent.getWorkbook();
    }

    protected Sheet getSheet() throws IOException {
        if (this._parent == null) {
            throw new IOException("Cannot find the sheet object");
        }
        return this._parent.getSheet();
    }

    protected Cell getCell() throws IOException {
        if (this._parent == null) {
            throw new IOException("Cannot find the cell object");
        }
        return this._parent.getCell();
    }

    public void initialize(Attribute[] attributes, ElementProcessor parent) throws IOException {
        try {
            this._parent = (BaseElementProcessor)parent;
        }
        catch (ClassCastException ignored) {
            throw new IOException("parent is not compatible with this serializer");
        }
        if (attributes != null) {
            int k = 0;
            while (k < attributes.length) {
                this._attributes.put(attributes[k].getName(), attributes[k]);
                ++k;
            }
        }
    }

    public void acceptCharacters(char[] data) {
        if (data != null) {
            this._data.append(data);
        }
    }

    public void acceptWhitespaceCharacters(char[] data) {
        if (data != null) {
            this._data.append(data);
        }
    }

    public void endProcessing() throws IOException {
        this._filesystem = null;
        this._parent = null;
    }

    public void setFilesystem(POIFSFileSystem fs) {
        this._filesystem = fs;
    }
}

