/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class HorizontalAlignment {
    private int _alignment;
    private static final int _general = 1;
    private static final int _left = 2;
    private static final int _right = 4;
    private static final int _center = 8;
    private static final int _fill = 16;
    private static final int _justify = 32;
    private static final int _center_across_selection = 64;
    private static final Validator _validator = new Validator(){

        public IOException validate(Number number) {
            int value = number.intValue();
            return value >= 0 && value <= 127 ? null : new IOException("\"" + number + "\" is out of range");
        }
    };

    public HorizontalAlignment(String value) throws IOException {
        this._alignment = NumericConverter.extractInteger(value, _validator).intValue();
    }

    public boolean isGeneral() {
        return (this._alignment & 1) == 1;
    }

    public boolean isLeft() {
        return (this._alignment & 2) == 2;
    }

    public boolean isRight() {
        return (this._alignment & 4) == 4;
    }

    public boolean isCenter() {
        return (this._alignment & 8) == 8;
    }

    public boolean isFill() {
        return (this._alignment & 0x10) == 16;
    }

    public boolean isJustify() {
        return (this._alignment & 0x20) == 32;
    }

    public boolean isCenterAcrossSelection() {
        return (this._alignment & 0x40) == 64;
    }

    short getCode() {
        return (short)this._alignment;
    }
}

