/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.types;

public class Attribute {
    private String _name;
    private String _value;

    public Attribute(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Attribute name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Attribute value is null");
        }
        this._name = name;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public int getValueAsInt() {
        return Integer.parseInt(this._value);
    }

    public short getValueAsShort() {
        return Short.parseShort(this._value);
    }

    public long getValueAsLong() {
        return Long.parseLong(this._value);
    }

    public boolean getValueAsBoolean() {
        boolean rvalue = false;
        if (this._value.equalsIgnoreCase("t") || this._value.equalsIgnoreCase("y") || this._value.equalsIgnoreCase("yes") || this._value.equalsIgnoreCase("true")) {
            rvalue = true;
        } else if (this._value.equalsIgnoreCase("f") || this._value.equalsIgnoreCase("n") || this._value.equalsIgnoreCase("no") || this._value.equalsIgnoreCase("false")) {
            rvalue = false;
        } else {
            throw new IllegalArgumentException("Value [" + this._value + "] does not represent a boolean value");
        }
        return rvalue;
    }
}

