/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.hsqldb;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.hsqldb.Server;
import org.apache.cocoon.environment.Context;

public class ServerImpl
extends AbstractLoggable
implements Server,
Parameterizable,
Contextualizable,
ThreadSafe,
Runnable,
Startable {
    private String port;
    private String[] arguments = new String[8];
    private boolean started = false;

    public void parameterize(Parameters params) {
        this.getLogger().debug("Parameterize ServerImpl");
        this.arguments[0] = "-port";
        this.arguments[1] = this.port = params.getParameter("port", "9002");
        this.arguments[2] = "-silent";
        this.arguments[3] = params.getParameter("silent", "true");
        this.arguments[4] = "-trace";
        this.arguments[5] = params.getParameter("trace", "false");
        this.arguments[4] = "-no_system_exit";
        this.arguments[5] = "true";
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configure ServerImpl with port: " + this.arguments[1] + ", silent: " + this.arguments[3] + ", trace: " + this.arguments[5]);
        }
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        Context ctx = (Context)context.get((Object)"environment-context");
        String dbPath = ctx.getRealPath("/WEB-INF/db");
        if (dbPath == null) {
            throw new ContextException("The hsqldb cannot be used inside a WAR file.");
        }
        try {
            this.arguments[6] = "-database";
            this.arguments[7] = new File(dbPath).getCanonicalPath();
            this.arguments[7] = this.arguments[7] + File.separator + "cocoondb";
            this.getLogger().debug("database is " + this.arguments[7]);
        }
        catch (MalformedURLException e) {
            this.getLogger().error("MalformedURLException - Could not get database directory ", (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("IOException - Could not get database directory ", (Throwable)e);
        }
    }

    public void start() {
        if (!this.started) {
            File file = new File(this.arguments[7] + ".backup");
            if (file.exists() && file.delete()) {
                this.getLogger().info("HSQLDB backup file has been deleted.");
            }
            Thread server = new Thread(this);
            this.getLogger().debug("Intializing hsqldb server thread");
            server.setPriority(Thread.currentThread().getPriority());
            server.setDaemon(true);
            server.setName("hsqldb server");
            server.start();
        }
    }

    public void stop() {
        if (this.started) {
            try {
                this.getLogger().debug("Shutting down HSQLDB");
                Connection connection = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost:" + this.port, "sa", "");
                Statement statement = connection.createStatement();
                statement.executeQuery("SHUTDOWN");
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    this.getLogger().debug("Shutting down HSQLDB: Ignoring exception: " + e);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Error while shutting down HSQLDB", (Throwable)e);
            }
            this.getLogger().debug("Shutting down HSQLDB: Done");
        }
    }

    public void run() {
        if (!this.started) {
            this.started = true;
            try {
                try {
                    this.getLogger().debug("HSQLDB Server arguments are as follows:");
                    int i = 0;
                    while (i < 8) {
                        this.getLogger().debug(i + " : " + this.arguments[i]);
                        ++i;
                    }
                    org.hsqldb.Server.main((String[])this.arguments);
                }
                catch (Exception e) {
                    this.getLogger().error("Got exception", (Throwable)e);
                    Object var3_4 = null;
                    this.started = false;
                }
                Object var3_3 = null;
                this.started = false;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.started = false;
                throw throwable;
            }
        }
    }
}

