/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import org.apache.avalon.framework.CascadingRuntimeException;

public class EsqlHelper {
    public static final byte[] getBlob(ResultSet set, String column) throws RuntimeException {
        byte[] result = null;
        try {
            result = EsqlHelper.getBlob(set, set.findColumn(column));
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting blob data for column " + column, (Throwable)e);
        }
        return result;
    }

    public static final byte[] getBlob(ResultSet set, int column) throws Exception {
        InputStream reader = null;
        byte[] buffer = null;
        try {
            if (set.getMetaData().getColumnType(column) == 2004) {
                Blob dbBlob = set.getBlob(column);
                int length = (int)dbBlob.length();
                reader = dbBlob.getBinaryStream();
                buffer = new byte[length];
                reader.read(buffer);
                reader.close();
                if (reader != null) {
                    reader.close();
                }
                if (buffer == null) {
                    return null;
                }
                return buffer;
            }
            return set.getString(column).getBytes();
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting blob data for column " + column, (Throwable)e);
        }
    }

    public static final byte[] getBlob(CallableStatement cs, int column, String defaultString) throws Exception {
        InputStream reader = null;
        byte[] buffer = null;
        Object result = null;
        try {
            Blob dbBlob = cs.getBlob(column);
            int length = (int)dbBlob.length();
            reader = dbBlob.getBinaryStream();
            buffer = new byte[length];
            reader.read(buffer);
            reader.close();
            if (reader != null) {
                reader.close();
            }
            result = buffer != null ? buffer : (Object)(defaultString != null && !defaultString.equals("_null_") ? defaultString.getBytes() : null);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting blob data for column " + column, (Throwable)e);
        }
        return result;
    }

    public static final String getStringOrClob(ResultSet set, String column, String defaultString) throws RuntimeException {
        String result = null;
        try {
            result = EsqlHelper.getStringOrClob(set, set.findColumn(column), defaultString);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting text data for column " + column, (Throwable)e);
        }
        return result;
    }

    public static final String getStringOrClob(ResultSet set, int column, String defaultString) throws Exception {
        BufferedReader reader = null;
        char[] buffer = null;
        String result = null;
        try {
            if (set.getMetaData().getColumnType(column) == 2005) {
                Clob dbClob = set.getClob(column);
                int length = (int)dbClob.length();
                reader = new BufferedReader(dbClob.getCharacterStream());
                buffer = new char[length];
                reader.read(buffer);
                ((Reader)reader).close();
                if (reader != null) {
                    ((Reader)reader).close();
                }
                result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
            } else {
                result = set.getString(column);
                if (result == null && defaultString != null && !defaultString.equals("_null_")) {
                    result = defaultString;
                }
            }
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting text data for column " + column, (Throwable)e);
        }
        return result;
    }

    public static final String getStringOrClob(CallableStatement cs, int column, String defaultString) throws Exception {
        BufferedReader reader = null;
        char[] buffer = null;
        String result = null;
        try {
            Clob dbClob = cs.getClob(column);
            int length = (int)dbClob.length();
            reader = new BufferedReader(dbClob.getCharacterStream());
            buffer = new char[length];
            reader.read(buffer);
            ((Reader)reader).close();
            if (reader != null) {
                ((Reader)reader).close();
            }
            result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting clob data for column " + column, (Throwable)e);
        }
        return result;
    }

    public static final String getAscii(ResultSet set, String column, String defaultString) throws RuntimeException {
        String result = null;
        try {
            result = EsqlHelper.getAscii(set, set.findColumn(column), defaultString);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error getting ascii data for column " + column, (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getAscii(ResultSet set, int column, String defaultString) {
        InputStream asciiStream = null;
        String result = null;
        try {
            block9: {
                try {
                    if (set.getMetaData().getColumnType(column) == 2005) {
                        byte[] buffer = null;
                        Clob dbClob = set.getClob(column);
                        int length = (int)dbClob.length();
                        asciiStream = new BufferedInputStream(dbClob.getAsciiStream());
                        buffer = new byte[length];
                        asciiStream.read(buffer);
                        asciiStream.close();
                        result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
                        break block9;
                    }
                    result = set.getString(column);
                    if (result == null && defaultString != null && !defaultString.equals("_null_")) {
                        result = defaultString;
                    }
                }
                catch (Exception e) {
                    throw new CascadingRuntimeException("Error getting ascii data for column " + column, (Throwable)e);
                }
            }
            Object var9_9 = null;
            if (asciiStream == null) return result;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (asciiStream == null) throw throwable;
            try {
                asciiStream.close();
                throw throwable;
            }
            catch (Exception ase) {
                throw new CascadingRuntimeException("Error closing clob stream", (Throwable)ase);
            }
        }
        try {}
        catch (Exception ase) {
            throw new CascadingRuntimeException("Error closing clob stream", (Throwable)ase);
        }
        asciiStream.close();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getAscii(CallableStatement cs, int column, String defaultString) {
        InputStream asciiStream = null;
        String result = null;
        try {
            try {
                byte[] buffer = null;
                Clob dbClob = cs.getClob(column);
                int length = (int)dbClob.length();
                asciiStream = new BufferedInputStream(dbClob.getAsciiStream());
                buffer = new byte[length];
                asciiStream.read(buffer);
                asciiStream.close();
                result = buffer != null ? new String(buffer) : (defaultString != null && !defaultString.equals("_null_") ? defaultString : null);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Error getting ascii data for colum " + column, (Throwable)e);
            }
            Object var9_9 = null;
            if (asciiStream == null) return result;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (asciiStream == null) throw throwable;
            try {
                asciiStream.close();
                throw throwable;
            }
            catch (Exception ase) {
                throw new CascadingRuntimeException("Error closing clob stream", (Throwable)ase);
            }
        }
        try {}
        catch (Exception ase) {
            throw new CascadingRuntimeException("Error closing clob stream", (Throwable)ase);
        }
        asciiStream.close();
        return result;
    }

    public static final String getStringFromByteArray(byte[] bytes, String encoding, String defaultString) {
        if (bytes != null) {
            try {
                return new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
            }
        }
        if (defaultString != null && !defaultString.equals("_null_")) {
            return defaultString;
        }
        return null;
    }
}

