/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.PackageFunctions;

public abstract class AbstractJXPathModule
extends AbstractInputModule {
    protected FunctionLibrary library = null;

    public void configure(Configuration config2) throws ConfigurationException {
        this.library = new FunctionLibrary();
        this.getFunctions(this.library, config2);
        this.getPackages(this.library, config2);
    }

    protected void getFunctions(FunctionLibrary lib, Configuration conf) {
        Configuration[] children = conf.getChildren("function");
        int i = children.length;
        while (i-- > 0) {
            String clazzName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (clazzName != null && prefix != null) {
                try {
                    Class<?> clazz = Class.forName(clazzName);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("adding Class " + clazzName + " to functions");
                    }
                    lib.addFunctions((Functions)new ClassFunctions(clazz, prefix));
                }
                catch (ClassNotFoundException cnf) {
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn("Class not found: " + clazzName);
                }
                continue;
            }
            if (!this.getLogger().isWarnEnabled()) continue;
            this.getLogger().warn("Class name or prefix null: " + clazzName + " / " + prefix);
        }
    }

    protected void getPackages(FunctionLibrary lib, Configuration conf) {
        Configuration[] children = conf.getChildren("package");
        int i = children.length;
        while (i-- > 0) {
            String packageName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (packageName != null && prefix != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("adding Package " + packageName + " to functions");
                }
                lib.addFunctions((Functions)new PackageFunctions(packageName, prefix));
                continue;
            }
            if (!this.getLogger().isWarnEnabled()) continue;
            this.getLogger().warn("Package name or prefix null: " + packageName + " / " + prefix);
        }
    }

    protected void setupExtensions(JXPathContext context, Configuration conf) {
        FunctionLibrary localLib = null;
        if (conf != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("adding local Classes and Packages to functions");
            }
            localLib = new FunctionLibrary();
            localLib.addFunctions((Functions)this.library);
            this.getPackages(localLib, conf);
            this.getFunctions(localLib, conf);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("no local Classes or Packages");
            }
            localLib = this.library;
        }
        context.setFunctions((Functions)localLib);
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        try {
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            this.setupExtensions(jxContext, modeConf);
            return jxContext.getValue(name);
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        try {
            JXPathBeanInfo info = JXPathIntrospector.getBeanInfo(contextObj.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            LinkedList<String> names = new LinkedList<String>();
            int i = 0;
            while (i < properties.length) {
                names.add(properties[i].getName());
                ++i;
            }
            return names.listIterator();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error retrieving attribute names for class: " + contextObj.getClass(), (Throwable)e);
        }
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        try {
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            LinkedList values = new LinkedList();
            this.setupExtensions(jxContext, modeConf);
            Iterator i = jxContext.iterate(name);
            while (i.hasNext()) {
                values.add(i.next());
            }
            return values.toArray();
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    protected abstract Object getContextObject(Configuration var1, Map var2) throws ConfigurationException;
}

