/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.components.modules.input.InputModule;

public abstract class AbstractMetaModule
extends AbstractInputModule
implements Initializable,
Composable,
Disposable {
    protected ComponentManager manager;
    protected ComponentSelector inputSelector = null;
    protected InputModule input = null;
    protected String defaultInput = "request-param";
    protected Configuration inputConf = null;
    protected Boolean initialized = new Boolean(false);
    protected static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void initialize() {
        block10: {
            try {
                Boolean bl = this.initialized;
                synchronized (bl) {
                    if (!this.initialized.booleanValue()) {
                        this.inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    }
                    if (this.inputSelector != null && this.inputSelector instanceof ThreadSafe) {
                        if (this.defaultInput != null) {
                            this.input = this.obtainModule(this.defaultInput);
                        }
                    } else if (!(this.inputSelector instanceof ThreadSafe)) {
                        this.manager.release((Component)this.inputSelector);
                        this.inputSelector = null;
                    }
                    this.initialized = new Boolean(true);
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block10;
                this.getLogger().warn("A problem occurred setting up input modules :'" + e.getMessage());
            }
        }
    }

    public void dispose() {
        if (!this.initialized.booleanValue()) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Uninitialized Component! FAILING");
            } else if (this.inputSelector != null) {
                if (this.input != null) {
                    this.inputSelector.release((Component)this.input);
                }
                this.manager.release((Component)this.inputSelector);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputModule obtainModule(String type) {
        ComponentSelector inputSelector = this.inputSelector;
        InputModule module = null;
        try {
            block9: {
                try {
                    if (inputSelector == null) {
                        inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    }
                    if (inputSelector.hasComponent((Object)type)) {
                        if (type != null && inputSelector.hasComponent((Object)type)) {
                            module = (InputModule)inputSelector.select((Object)type);
                        }
                        if (!(module instanceof ThreadSafe)) {
                            inputSelector.release(module);
                            module = null;
                        }
                    }
                    if (type == null || module != null || !this.getLogger().isWarnEnabled()) break block9;
                    this.getLogger().warn("A problem occurred setting up '" + type + "': Selector is " + (inputSelector != null ? "not " : "") + "null, Component is " + (inputSelector != null && inputSelector.hasComponent((Object)type) ? "known" : "unknown"));
                }
                catch (ComponentException ce) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not obtain selector for InputModules: " + ce.getMessage());
                    }
                    Object var6_5 = null;
                    if (this.inputSelector != null) return module;
                    this.manager.release((Component)inputSelector);
                    return module;
                }
            }
            Object var6_4 = null;
            if (this.inputSelector != null) return module;
            this.manager.release((Component)inputSelector);
            return module;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.inputSelector != null) throw throwable;
            this.manager.release((Component)inputSelector);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void releaseModule(InputModule module) {
        ComponentSelector inputSelector = this.inputSelector;
        if (module == null) return;
        try {
            try {
                if (inputSelector == null) {
                    inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                }
                inputSelector.release((Component)module);
                module = null;
            }
            catch (ComponentException ce) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Could not obtain selector for InputModules: " + ce.getMessage());
                }
                Object var5_4 = null;
                if (this.inputSelector != null) return;
                this.manager.release((Component)inputSelector);
                return;
            }
            Object var5_3 = null;
            if (this.inputSelector != null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.inputSelector != null) throw throwable;
            this.manager.release((Component)inputSelector);
            throw throwable;
        }
        this.manager.release((Component)inputSelector);
    }

    protected Iterator getNames(Map objectModel, InputModule modA, String modAName, Configuration modAConf) {
        return (Iterator)this.get(2, null, objectModel, modA, modAName, modAConf, null, null, null);
    }

    protected Iterator getNames(Map objectModel, InputModule modA, String modAName, Configuration modAConf, InputModule modB, String modBName, Configuration modBConf) {
        return (Iterator)this.get(2, null, objectModel, modA, modAName, modAConf, modB, modBName, modBConf);
    }

    protected Object getValue(String attr, Map objectModel, InputModule modA, String modAName, Configuration modAConf) {
        return this.get(0, attr, objectModel, modA, modAName, modAConf, null, null, null);
    }

    protected Object getValue(String attr, Map objectModel, InputModule modA, String modAName, Configuration modAConf, InputModule modB, String modBName, Configuration modBConf) {
        return this.get(0, attr, objectModel, modA, modAName, modAConf, modB, modBName, modBConf);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule modA, String modAName, Configuration modAConf) {
        return (Object[])this.get(1, attr, objectModel, modA, modAName, modAConf, null, null, null);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule modA, String modAName, Configuration modAConf, InputModule modB, String modBName, Configuration modBConf) {
        return (Object[])this.get(1, attr, objectModel, modA, modAName, modAConf, modB, modBName, modBConf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object get(int op, String attr, Map objectModel, InputModule modA, String modAName, Configuration modAConf, InputModule modB, String modBName, Configuration modBConf) {
        ComponentSelector cs = this.inputSelector;
        Object[] value = null;
        String name = null;
        InputModule input = null;
        Configuration conf = null;
        boolean release = false;
        try {
            try {
                if (cs == null) {
                    cs = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                }
                if (modB == null) {
                    input = modA;
                    name = modAName;
                    conf = modAConf;
                } else {
                    input = modB;
                    name = modBName;
                    conf = modBConf;
                }
                if (input == null) {
                    if (cs.hasComponent((Object)name)) {
                        release = true;
                        input = (InputModule)cs.select((Object)name);
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("No such InputModule: " + name);
                    }
                }
                switch (op) {
                    case 0: {
                        value = input.getAttribute(attr, conf, objectModel);
                        break;
                    }
                    case 1: {
                        value = input.getAttributeValues(attr, conf, objectModel);
                        break;
                    }
                    case 2: {
                        value = input.getAttributeNames(conf, objectModel);
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("A problem obtaining a value from " + name + " occurred : " + e.getMessage());
                }
                Object var18_17 = null;
                if (release) {
                    cs.release((Component)input);
                }
                if (this.inputSelector != null) return value;
                this.manager.release((Component)cs);
                return value;
            }
            {
            }
            Object var18_16 = null;
            if (release) {
                cs.release((Component)input);
            }
            if (this.inputSelector != null) return value;
            this.manager.release((Component)cs);
            return value;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            if (release) {
                cs.release((Component)input);
            }
            if (this.inputSelector != null) throw throwable;
            this.manager.release((Component)cs);
            throw throwable;
        }
    }
}

