/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.saxconnector.SAXConnector;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.sitemap.ErrorNotifier;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.cocoon.xml.XMLPipe;
import org.apache.cocoon.xml.XMLProducer;
import org.xml.sax.SAXException;

public abstract class AbstractEventPipeline
extends AbstractXMLProducer
implements EventPipeline,
Disposable {
    protected Generator generator;
    protected Parameters generatorParam;
    protected String generatorSource;
    protected ComponentSelector generatorSelector;
    protected ArrayList transformers = new ArrayList();
    protected ArrayList transformerParams = new ArrayList();
    protected ArrayList transformerSources = new ArrayList();
    protected ArrayList transformerSelectors = new ArrayList();
    protected ArrayList connectors = new ArrayList();
    protected ComponentManager manager;
    protected boolean configuredSAXConnector;
    protected ComponentManager newManager;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.configuredSAXConnector = this.manager.hasComponent("org.apache.cocoon.components.saxconnector.SAXConnector");
        this.newManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.newManager = manager;
    }

    public void setGenerator(String role, String source, Parameters param, Exception e) throws Exception {
        this.setGenerator(role, source, param);
        if (this.generator instanceof ErrorNotifier) {
            ((ErrorNotifier)this.generator).setThrowable(e);
        }
    }

    public void setGenerator(String role, String source, Parameters param) throws Exception {
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. You can only select one Generator (" + role + ")");
        }
        this.generatorSelector = (ComponentSelector)this.newManager.lookup("org.apache.cocoon.generation.GeneratorSelector");
        this.generator = (Generator)this.generatorSelector.select((Object)role);
        this.generatorSource = source;
        this.generatorParam = param;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void addTransformer(String role, String source, Parameters param) throws Exception {
        ComponentSelector selector = (ComponentSelector)this.newManager.lookup("org.apache.cocoon.transformation.TransformerSelector");
        this.transformerSelectors.add(selector);
        this.transformers.add((Transformer)selector.select((Object)role));
        this.transformerSources.add(source);
        this.transformerParams.add(param);
    }

    public boolean process(Environment environment) throws Exception {
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        this.setupPipeline(environment);
        this.connectPipeline(environment);
        this.generator.generate();
        return true;
    }

    protected boolean checkPipeline() {
        if (this.generator == null) {
            return false;
        }
        Iterator itt = this.transformers.iterator();
        while (itt.hasNext()) {
            if (itt.next() != null) continue;
            return false;
        }
        return this.xmlConsumer != null || this.contentHandler != null || this.lexicalHandler != null;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        try {
            this.generator.setup(environment, environment.getObjectModel(), this.generatorSource, this.generatorParam);
            Iterator transformerItt = this.transformers.iterator();
            Iterator transformerSourceItt = this.transformerSources.iterator();
            Iterator transformerParamItt = this.transformerParams.iterator();
            while (transformerItt.hasNext()) {
                Transformer trans = (Transformer)transformerItt.next();
                trans.setup(environment, environment.getObjectModel(), (String)transformerSourceItt.next(), (Parameters)transformerParamItt.next());
            }
        }
        catch (SAXException e) {
            throw new ProcessingException("Could not setup pipeline.", e);
        }
        catch (IOException e) {
            throw new ProcessingException("Could not setup pipeline.", e);
        }
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        XMLProducer prev = this.generator;
        try {
            XMLPipe next;
            SAXConnector connect;
            Iterator itt = this.transformers.iterator();
            while (itt.hasNext()) {
                Transformer trans;
                if (this.configuredSAXConnector) {
                    connect = (SAXConnector)this.manager.lookup("org.apache.cocoon.components.saxconnector.SAXConnector");
                    connect.setup(environment, environment.getObjectModel(), null, null);
                    this.connectors.add(connect);
                    next = connect;
                    prev.setConsumer(next);
                    prev = connect;
                }
                next = trans = (Transformer)itt.next();
                prev.setConsumer(next);
                prev = trans;
            }
            if (this.configuredSAXConnector) {
                connect = (SAXConnector)this.manager.lookup("org.apache.cocoon.components.saxconnector.SAXConnector");
                connect.setup(environment, environment.getObjectModel(), null, null);
                this.connectors.add(connect);
                next = connect;
                prev.setConsumer(next);
                prev = connect;
            }
            prev.setConsumer(this.xmlConsumer);
        }
        catch (IOException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
        catch (SAXException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
        catch (ComponentException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
    }

    public void recycle() {
        super.recycle();
        try {
            try {
                if (this.generatorSelector != null) {
                    this.generatorSelector.release((Component)this.generator);
                }
                int size = this.transformerSelectors.size();
                int i = 0;
                while (i < size) {
                    ((ComponentSelector)this.transformerSelectors.get(i)).release((Component)this.transformers.get(i));
                    ++i;
                }
                Iterator itc = this.connectors.iterator();
                while (itc.hasNext()) {
                    this.manager.release((Component)itc.next());
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to release components from event pipeline.", (Throwable)e);
                Object var5_6 = null;
                this.generatorSelector = null;
                this.generator = null;
                this.generatorParam = null;
                this.transformerSelectors.clear();
                this.transformers.clear();
                this.transformerParams.clear();
                this.transformerSources.clear();
                this.connectors.clear();
            }
            Object var5_5 = null;
            this.generatorSelector = null;
            this.generator = null;
            this.generatorParam = null;
            this.transformerSelectors.clear();
            this.transformers.clear();
            this.transformerParams.clear();
            this.transformerSources.clear();
            this.connectors.clear();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.generatorSelector = null;
            this.generator = null;
            this.generatorParam = null;
            this.transformerSelectors.clear();
            this.transformers.clear();
            this.transformerParams.clear();
            this.transformerSources.clear();
            this.connectors.clear();
            throw throwable;
        }
    }

    public void dispose() {
    }
}

