/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.components.store.StoreJanitor;

public class StoreJanitorImpl
extends AbstractLoggable
implements StoreJanitor,
Configurable,
ThreadSafe,
Runnable,
Startable {
    private int freememory = -1;
    private int heapsize = -1;
    private int cleanupthreadinterval = -1;
    private int priority = -1;
    private Runtime jvm;
    private ArrayList storelist;
    private int index = -1;
    private static boolean doRun = false;
    private double fraction;

    public void configure(Configuration conf) throws ConfigurationException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configure StoreJanitorImpl");
        }
        this.setJVM(Runtime.getRuntime());
        Parameters params = Parameters.fromConfiguration((Configuration)conf);
        this.setFreememory(params.getParameterAsInteger("freememory", 1000000));
        this.setHeapsize(params.getParameterAsInteger("heapsize", 60000000));
        this.setCleanupthreadinterval(params.getParameterAsInteger("cleanupthreadinterval", 10));
        this.setPriority(params.getParameterAsInteger("threadpriority", Thread.currentThread().getPriority()));
        int percent = params.getParameterAsInteger("percent_to_free", 10);
        if (this.getFreememory() < 1) {
            throw new ConfigurationException("StoreJanitorImpl freememory parameter has to be greater then 1");
        }
        if (this.getHeapsize() < 1) {
            throw new ConfigurationException("StoreJanitorImpl heapsize parameter has to be greater then 1");
        }
        if (this.getCleanupthreadinterval() < 1) {
            throw new ConfigurationException("StoreJanitorImpl cleanupthreadinterval parameter has to be greater then 1");
        }
        if (this.getPriority() < 1) {
            throw new ConfigurationException("StoreJanitorImpl threadpriority has to be greater then 1");
        }
        if (percent > 100 && percent < 1) {
            throw new ConfigurationException("StoreJanitorImpl percent_to_free, has to be between 1 and 100");
        }
        this.fraction = (double)percent / 100.0;
        this.setStoreList(new ArrayList());
    }

    public void start() {
        doRun = true;
        Thread checker = new Thread(this);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Intializing checker thread");
        }
        checker.setPriority(this.getPriority());
        checker.setDaemon(true);
        checker.setName("checker");
        checker.start();
    }

    public void stop() {
        doRun = false;
    }

    public void run() {
        while (doRun) {
            if (this.memoryLow()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Invoking garbage collection, total memory = " + this.getJVM().totalMemory() + ", free memory = " + this.getJVM().freeMemory());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Garbage collection complete, total memory = " + this.getJVM().totalMemory() + ", free memory = " + this.getJVM().freeMemory());
                }
                StoreJanitorImpl storeJanitorImpl = this;
                synchronized (storeJanitorImpl) {
                    if (this.memoryLow() && this.getStoreList().size() > 0) {
                        this.freeMemory();
                        this.setIndex(this.getIndex() + 1);
                    }
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.cleanupthreadinterval * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean memoryLow() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JVM total Memory: " + this.getJVM().totalMemory());
            this.getLogger().debug("JVM free Memory: " + this.getJVM().freeMemory());
        }
        if (this.getJVM().totalMemory() >= (long)this.getHeapsize() && this.getJVM().freeMemory() < (long)this.getFreememory()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Memory is low = true");
            }
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Memory is low = false");
        }
        return false;
    }

    public void register(Store store) {
        this.getStoreList().add(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Registering store instance");
            this.getLogger().debug("Size of StoreJanitor now:" + this.getStoreList().size());
        }
    }

    public void unregister(Store store) {
        this.getStoreList().remove(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Unregister store instance");
            this.getLogger().debug("Size of StoreJanitor now:" + this.getStoreList().size());
        }
    }

    public Iterator iterator() {
        return this.getStoreList().iterator();
    }

    private void freeMemory() {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("StoreList size=" + this.getStoreList().size());
                this.getLogger().debug("Actual Index position: " + this.getIndex());
            }
            if (this.getIndex() < this.getStoreList().size()) {
                if (this.getIndex() == -1) {
                    this.setIndex(0);
                    Store store = (Store)this.getStoreList().get(this.getIndex());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Freeing Store: " + this.getIndex());
                    }
                    int limit = this.calcToFree(store);
                    int i = 0;
                    while (i < limit) {
                        store.free();
                        ++i;
                    }
                } else {
                    Store store = (Store)this.getStoreList().get(this.getIndex());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Freeing Store: " + this.getIndex());
                    }
                    int limit = this.calcToFree(store);
                    int i = 0;
                    while (i < limit) {
                        store.free();
                        ++i;
                    }
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Starting from the beginning");
                }
                this.resetIndex();
                this.setIndex(0);
                Store store = (Store)this.getStoreList().get(this.getIndex());
                int limit = this.calcToFree(store);
                int i = 0;
                while (i < limit) {
                    store.free();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error in freeMemory()", (Throwable)e);
        }
    }

    private int calcToFree(Store store) {
        int cnt = store.size();
        if (cnt < 0) {
            this.getLogger().debug("Unknown size of the store: " + store);
            return 0;
        }
        return (int)((double)cnt * this.fraction);
    }

    private void freePhysicalMemory() {
        this.getJVM().runFinalization();
        this.getJVM().gc();
    }

    private int getFreememory() {
        return this.freememory;
    }

    private void setFreememory(int _freememory) {
        this.freememory = _freememory;
    }

    private int getHeapsize() {
        return this.heapsize;
    }

    private void setHeapsize(int _heapsize) {
        this.heapsize = _heapsize;
    }

    private int getCleanupthreadinterval() {
        return this.cleanupthreadinterval;
    }

    private void setCleanupthreadinterval(int _cleanupthreadinterval) {
        this.cleanupthreadinterval = _cleanupthreadinterval;
    }

    private int getPriority() {
        return this.priority;
    }

    private void setPriority(int _priority) {
        this.priority = _priority;
    }

    private Runtime getJVM() {
        return this.jvm;
    }

    private void setJVM(Runtime _runtime) {
        this.jvm = _runtime;
    }

    private ArrayList getStoreList() {
        return this.storelist;
    }

    private void setStoreList(ArrayList _storelist) {
        this.storelist = _storelist;
    }

    private void setIndex(int _index) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting index=" + _index);
        }
        this.index = _index;
    }

    private int getIndex() {
        return this.index;
    }

    private void resetIndex() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Reseting index");
        }
        this.index = -1;
    }
}

