/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.NamedProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelinesNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class ActionSetNode
extends SimpleSelectorProcessingNode
implements Disposable,
NamedProcessingNode,
Composable {
    private String[] types;
    private String[] actionNames;
    private Action[] threadSafeActions;
    private VariableResolver[] sources;
    private Map[] parameters;
    protected ComponentManager manager;

    public ActionSetNode(String name, String[] types, String[] actionNames, VariableResolver[] sources, Map[] parameters) {
        super(name);
        this.types = types;
        this.actionNames = actionNames;
        this.sources = sources;
        this.parameters = parameters;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.setSelector((ComponentSelector)manager.lookup("org.apache.cocoon.acting.ActionSelector"));
        this.threadSafeActions = new Action[this.types.length];
        int i = 0;
        while (i < this.types.length) {
            this.threadSafeActions[i] = (Action)this.getThreadSafeComponent(this.types[i]);
            ++i;
        }
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        String msg = "An action-set cannot be invoked, at " + this.getLocation();
        this.getLogger().error(msg);
        throw new UnsupportedOperationException(msg);
    }

    public final Map call(Environment env, InvokeContext context, Parameters params) throws Exception {
        Map objectModel = env.getObjectModel();
        Redirector redirector = PipelinesNode.getRedirector(env);
        SourceResolver resolver = AbstractProcessingNode.getSourceResolver(objectModel);
        String cocoonAction = env.getAction();
        HashMap result = null;
        int i = 0;
        while (i < this.types.length) {
            String actionName = this.actionNames[i];
            String source = this.sources[i].resolve(context, objectModel);
            if (actionName == null || actionName.equals(cocoonAction)) {
                Map actionResult;
                Parameters actionParams = VariableResolver.buildParameters(this.parameters[i], context, objectModel);
                if (actionParams == Parameters.EMPTY_PARAMETERS) {
                    actionParams = params;
                } else {
                    actionParams.merge(params);
                }
                Action action = this.threadSafeActions[i];
                if (action != null) {
                    actionResult = action.act(redirector, resolver, objectModel, source, actionParams);
                } else {
                    Object var16_15;
                    action = (Action)this.selector.select((Object)this.types[i]);
                    try {
                        actionResult = action.act(redirector, resolver, objectModel, source, actionParams);
                        var16_15 = null;
                    }
                    catch (Throwable throwable) {
                        var16_15 = null;
                        this.selector.release((Component)action);
                        throw throwable;
                    }
                    this.selector.release((Component)action);
                    {
                    }
                }
                if (actionResult != null) {
                    if (result == null) {
                        result = new HashMap(actionResult);
                    } else {
                        result.putAll(actionResult);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public void dispose() {
        int i = 0;
        while (i < this.threadSafeActions.length) {
            this.selector.release((Component)this.threadSafeActions[i]);
            ++i;
        }
        this.manager.release((Component)this.selector);
    }

    public String getName() {
        return this.componentName;
    }
}

