/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ComponentsSelector;
import org.apache.cocoon.components.treeprocessor.sitemap.SelectNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.selection.Selector;

public class SelectNodeBuilder
extends AbstractParentProcessingNodeBuilder {
    private static final String SELECTOR_ROLE = "org.apache.cocoon.selection.SelectorSelector";

    public ProcessingNode buildNode(Configuration config2) throws Exception {
        String type = this.treeBuilder.getTypeForStatement(config2, SELECTOR_ROLE);
        ArrayList<ProcessingNode[]> whenChildren = new ArrayList<ProcessingNode[]>();
        ArrayList<VariableResolver> whenTests = new ArrayList<VariableResolver>();
        ProcessingNode[] otherwiseNodes = null;
        Configuration[] childrenConfig = config2.getChildren();
        int i = 0;
        while (i < childrenConfig.length) {
            Configuration childConfig = childrenConfig[i];
            String name = childConfig.getName();
            if ("when".equals(name)) {
                this.checkNamespace(childConfig);
                whenTests.add(VariableResolverFactory.getResolver(childConfig.getAttribute("test"), this.manager));
                whenChildren.add(this.buildChildNodes(childConfig));
            } else if ("otherwise".equals(name)) {
                this.checkNamespace(childConfig);
                if (otherwiseNodes != null) {
                    String msg = "Duplicate " + name + " (only one is allowed) at " + childConfig.getLocation();
                    this.getLogger().error(msg);
                    throw new ConfigurationException(msg);
                }
                otherwiseNodes = this.buildChildNodes(childConfig);
            } else if (!this.isParameter(childConfig)) {
                String msg = "Unknown element '" + name + "' in select at " + childConfig.getLocation();
                throw new ConfigurationException(msg);
            }
            ++i;
        }
        ProcessingNode[][] whenChildrenNodes = (ProcessingNode[][])whenChildren.toArray((T[])new ProcessingNode[0][0]);
        VariableResolver[] whenResolvers = whenTests.toArray(new VariableResolver[whenTests.size()]);
        ComponentsSelector compSelector = (ComponentsSelector)this.manager.lookup(SELECTOR_ROLE);
        Class<?> clazz = null;
        try {
            Selector selector = (Selector)compSelector.select(type);
            try {
                clazz = selector.getClass();
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                compSelector.release(selector);
                throw throwable;
            }
            compSelector.release(selector);
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            this.manager.release((Component)compSelector);
            throw throwable;
        }
        this.manager.release((Component)compSelector);
        SelectNode node = new SelectNode(type);
        this.treeBuilder.setupNode(node, config2);
        node.setCases(whenChildrenNodes, whenResolvers, otherwiseNodes);
        return node;
    }
}

