/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.log.Logger;

public class ForwardRedirector
extends AbstractLoggable
implements Redirector {
    private boolean hasRedirected = false;
    private Environment env;
    private Processor processor;
    private ComponentManager manager;
    private StreamPipeline streamPipe;
    private EventPipeline eventPipe;

    public ForwardRedirector(Environment env, Processor processor, ComponentManager manager, EventPipeline eventPipe, StreamPipeline streamPipe) {
        this.env = env;
        this.processor = processor;
        this.manager = manager;
        this.streamPipe = streamPipe;
        this.eventPipe = eventPipe;
    }

    public void redirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(sessionMode, url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    public void globalRedirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(sessionMode, url);
        } else if (this.env instanceof EnvironmentWrapper) {
            ((EnvironmentWrapper)this.env).globalRedirect(sessionMode, url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    private void cocoonRedirect(boolean sessionMode, String uri) throws IOException, ProcessingException {
        try {
            Processor actualProcessor;
            String prefix;
            boolean rawMode = false;
            int protocolEnd = uri.indexOf(58);
            if (protocolEnd != -1 && (uri = uri.substring(protocolEnd + 1)).startsWith("raw:")) {
                uri = uri.substring(4);
                rawMode = true;
            }
            if (uri.startsWith("//")) {
                uri = uri.substring(2);
                prefix = "";
                try {
                    actualProcessor = (Processor)this.manager.lookup("org.apache.cocoon.Processor");
                }
                catch (ComponentException e) {
                    throw new ProcessingException("Cannot get Processor instance", e);
                }
            } else if (uri.startsWith("/")) {
                prefix = null;
                uri = uri.substring(1);
                actualProcessor = this.processor;
            } else {
                throw new ProcessingException("Malformed cocoon URI.");
            }
            String queryString = null;
            int queryStringPos = uri.indexOf(63);
            if (queryStringPos != -1) {
                queryString = uri.substring(queryStringPos + 1);
                uri = uri.substring(0, queryStringPos);
            }
            String requestURI = prefix == null ? this.env.getURIPrefix() + uri : uri;
            ForwardEnvironmentWrapper newEnv = new ForwardEnvironmentWrapper(this.env, requestURI, queryString, this.getLogger(), rawMode);
            newEnv.setURI(prefix, uri);
            boolean processingResult = this.eventPipe == null && this.streamPipe == null ? actualProcessor.process(newEnv) : actualProcessor.process(newEnv, this.streamPipe, this.eventPipe);
            if (!processingResult) {
                throw new ProcessingException("Couldn't process URI " + requestURI);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception e) {
            String msg = "Error while redirecting to " + uri;
            this.getLogger().error(msg, (Throwable)e);
            throw new ProcessingException(msg, e);
        }
    }

    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    private final class ForwardEnvironmentWrapper
    extends EnvironmentWrapper {
        public ForwardEnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, boolean rawMode) throws MalformedURLException {
            super(env, requestURI, queryString, logger, rawMode);
        }

        public void setStatus(int statusCode) {
            this.environment.setStatus(statusCode);
        }

        public void setContentLength(int length) {
            this.environment.setContentLength(length);
        }

        public void setContentType(String contentType) {
            this.environment.setContentType(contentType);
        }

        public String getContentType() {
            return this.environment.getContentType();
        }
    }
}

