/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.excalibur.xml.xpath.XPathProcessor;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.TimeStampCacheValidity;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.URLFactorySourceResolver;
import org.apache.cocoon.generation.ComposerGenerator;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class HTMLGenerator
extends ComposerGenerator
implements Configurable,
Cacheable,
Disposable {
    private Source inputSource;
    private String xpath = null;
    private XPathProcessor processor = null;
    private Properties properties;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        try {
            this.processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
        }
        catch (Exception e) {
            this.getLogger().error("cannot obtain XPathProcessor", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration config2) throws ConfigurationException {
        String configUrl = config2.getChild("jtidy-config").getValue(null);
        if (configUrl == null) return;
        URLFactory urlFactory = null;
        Source configSource = null;
        try {
            try {
                urlFactory = (URLFactory)this.manager.lookup("org.apache.cocoon.components.url.URLFactory");
                URLFactorySourceResolver urlResolver = new URLFactorySourceResolver(urlFactory, this.manager);
                configSource = urlResolver.resolve(configUrl);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Loading configuration from " + configSource.getSystemId());
                }
                this.properties = new Properties();
                this.properties.load(configSource.getInputStream());
            }
            catch (Exception e) {
                this.getLogger().warn("Cannot load configuration from " + configUrl);
                throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.manager.release((Component)urlFactory);
            if (configSource == null) throw throwable;
            configSource.recycle();
            throw throwable;
        }
        this.manager.release((Component)urlFactory);
        if (configSource == null) return;
        configSource.recycle();
    }

    public void recycle() {
        super.recycle();
        if (this.inputSource != null) {
            this.inputSource.recycle();
            this.inputSource = null;
        }
        this.xpath = null;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        Request request = ObjectModelHelper.getRequest(objectModel);
        this.xpath = request.getParameter("xpath");
        if (this.xpath == null) {
            this.xpath = par.getParameter("xpath", null);
        }
        if (par.getParameterAsBoolean("copy-parameters", false) && request.getQueryString() != null) {
            StringBuffer query = new StringBuffer(this.source);
            query.append(this.source.indexOf("?") == -1 ? (char)'?' : '&');
            query.append(request.getQueryString());
            this.source = query.toString();
        }
        this.inputSource = resolver.resolve(this.source);
    }

    public long generateKey() {
        if (this.inputSource.getLastModified() != 0L) {
            if (this.xpath != null) {
                StringBuffer buffer = new StringBuffer(this.inputSource.getSystemId());
                buffer.append(':').append(this.xpath);
                return HashUtil.hash(buffer.toString());
            }
            return HashUtil.hash(this.inputSource.getSystemId());
        }
        return 0L;
    }

    public CacheValidity generateValidity() {
        if (this.inputSource.getLastModified() != 0L) {
            return new TimeStampCacheValidity(this.inputSource.getLastModified());
        }
        return null;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Tidy tidy = new Tidy();
            tidy.setXmlOut(true);
            if (this.properties == null) {
                tidy.setXHTML(true);
            } else {
                tidy.setConfigurationFromProps(this.properties);
            }
            tidy.setShowWarnings(this.getLogger().isWarnEnabled());
            tidy.setQuiet(!this.getLogger().isInfoEnabled());
            StringWriter stringWriter = new StringWriter();
            PrintWriter errorWriter = new PrintWriter(stringWriter);
            tidy.setErrout(errorWriter);
            Document doc = tidy.parseDOM((InputStream)new BufferedInputStream(this.inputSource.getInputStream()), null);
            XMLUtils.stripDuplicateAttributes(doc, null);
            errorWriter.flush();
            errorWriter.close();
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(stringWriter.toString());
            }
            if (this.xpath != null) {
                Transformer serializer = TransformerFactory.newInstance().newTransformer();
                serializer.setOutputProperty("omit-xml-declaration", "yes");
                NodeList nl = this.processor.selectNodeList((Node)doc, this.xpath);
                int length = nl.getLength();
                int i = 0;
                while (i < length) {
                    SAXResult result = new SAXResult(this.contentHandler);
                    result.setLexicalHandler(this.lexicalHandler);
                    serializer.transform(new DOMSource(nl.item(i)), result);
                    ++i;
                }
            } else {
                DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
                streamer.stream(doc);
            }
        }
        catch (IOException e) {
            this.getLogger().warn("HTMLGenerator.generate()", (Throwable)e);
            throw new ResourceNotFoundException("Could not get resource " + this.inputSource.getSystemId(), e);
        }
        catch (SAXException e) {
            this.getLogger().error("HTMLGenerator.generate()", (Throwable)e);
            throw e;
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("Could not setup jtidy", (Throwable)e);
            throw new ProcessingException("Exception in HTMLGenerator.generate()", e);
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.processor);
        }
        this.processor = null;
        super.dispose();
    }
}

