/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.jsp.JSPEngine;
import org.apache.cocoon.generation.ServletGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JspGenerator
extends ServletGenerator
implements Configurable {
    public void configure(Configuration conf) throws ConfigurationException {
    }

    public void generate() throws ProcessingException {
        HttpServletResponse httpResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
        HttpServletRequest httpRequest = (HttpServletRequest)this.objectModel.get("httprequest");
        ServletContext httpContext = (ServletContext)this.objectModel.get("httpservletcontext");
        if (httpResponse == null || httpRequest == null || httpContext == null) {
            throw new ProcessingException("HttpServletRequest or HttpServletResponse or ServletContext object not available");
        }
        JSPEngine engine = null;
        Parser parser = null;
        try {
            try {
                String url = this.source;
                if (!url.startsWith("/")) {
                    String servletPath = httpRequest.getServletPath();
                    servletPath = servletPath.substring(0, servletPath.lastIndexOf(47) + 1);
                    url = servletPath + url;
                }
                engine = (JSPEngine)this.manager.lookup("org.apache.cocoon.components.jsp.JSPEngine");
                this.getLogger().debug("JspGenerator executing JSP:" + url);
                byte[] bytes = engine.executeJSP(url, httpRequest, httpResponse, httpContext);
                InputSource input = new InputSource(new ByteArrayInputStream(bytes));
                input.setEncoding("utf-8");
                parser = (Parser)this.manager.lookup(Parser.ROLE);
                parser.parse(input, (ContentHandler)this.xmlConsumer);
            }
            catch (ServletException e) {
                this.getLogger().debug("ServletException in JspGenerator.generate()", (Throwable)e);
                this.getLogger().debug("Embedded ServletException JspGenerator.generate()", e.getRootCause());
                throw new ProcessingException("ServletException in JspGenerator.generate()", e.getRootCause());
            }
            catch (SAXException e) {
                this.getLogger().debug("SAXException JspGenerator.generate()", (Throwable)e);
                this.getLogger().debug("Embedded SAXException JspGenerator.generate()", (Throwable)e.getException());
                throw new ProcessingException("SAXException JspGenerator.generate()", e.getException());
            }
            catch (IOException e) {
                this.getLogger().debug("IOException in JspGenerator.generate()", (Throwable)e);
                throw new ProcessingException("IOException JspGenerator.generate()", e);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                this.getLogger().debug("Exception in JspGenerator.generate()", (Throwable)e);
                throw new ProcessingException("Exception JspGenerator.generate()", e);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.manager.release(parser);
            this.manager.release(engine);
            throw throwable;
        }
        this.manager.release((Component)parser);
        this.manager.release((Component)engine);
    }
}

