/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.DefaultComponentSelector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.i18n.XMLResourceBundle;
import org.apache.log.Logger;
import org.xml.sax.SAXParseException;

public class XMLResourceBundleFactory
extends DefaultComponentSelector
implements Configurable,
Composable,
Loggable,
Disposable,
ThreadSafe {
    protected boolean cacheAtStartup = false;
    protected String directory;
    protected Map cacheNotFound = new HashMap();
    protected Logger logger;
    protected ComponentManager manager = null;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void dispose() {
        Collection bundles = this.getComponentMap().values();
        Iterator i = bundles.iterator();
        while (i.hasNext()) {
            Object bundle = i.next();
            if (!(bundle instanceof Disposable)) continue;
            ((Disposable)bundle).dispose();
        }
        this.manager = null;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.cacheAtStartup = configuration.getChild("cache-at-startup").getValueAsBoolean(false);
        try {
            this.directory = configuration.getChild("catalogue-location", true).getValue();
        }
        catch (ConfigurationException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Root directory not provided in configuration, using default (root).");
            }
            this.directory = "";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("XMLResourceBundleFactory configured with: cacheAtStartup = " + this.cacheAtStartup + ", directory = '" + this.directory + "'");
        }
    }

    public Component select(String name, Locale locale) throws ComponentException {
        return this.select(name, locale, this.cacheAtStartup);
    }

    public Component select(String name, Locale loc, boolean cacheAtStartup) throws ComponentException {
        Component bundle = this._select(name, loc, cacheAtStartup);
        if (bundle == null) {
            throw new ComponentException("Unable to locate resource: " + name);
        }
        return bundle;
    }

    private Component _select(String name, Locale loc) {
        return this._select(name, loc, this.cacheAtStartup);
    }

    protected Component selectParent(String name, Locale loc) {
        return this.selectParent(name, loc, this.cacheAtStartup);
    }

    protected Component selectParent(String name, Locale loc, boolean cacheAtStartup) {
        return this._select(name, this.getParentLocale(loc), cacheAtStartup);
    }

    public Component select(String name, String localeName) throws ComponentException {
        return this.select(name, new Locale(localeName, localeName));
    }

    public Component selectFromFilename(String fileName) throws ComponentException {
        return this.selectFromFilename(fileName, this.cacheAtStartup);
    }

    public Component selectFromFilename(String fileName, boolean cacheAtStartup) throws ComponentException {
        Component bundle = this._select(fileName, null, cacheAtStartup);
        if (bundle == null) {
            throw new ComponentException("Unable to locate resource: " + fileName);
        }
        return bundle;
    }

    private Component _select(String name, Locale loc, boolean cacheAtStartup) {
        String fileName;
        XMLResourceBundle bundle;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("_getBundle: " + name + ", locale " + loc);
        }
        if ((bundle = (XMLResourceBundle)this.selectCached(fileName = this.getFileName(name, loc))) == null && !this.isNotFoundBundle(fileName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("not found in cache, loading: " + fileName);
            }
            XMLResourceBundleFactory xMLResourceBundleFactory = this;
            synchronized (xMLResourceBundleFactory) {
                bundle = (XMLResourceBundle)this.selectCached(fileName);
                if (bundle == null && !this.isNotFoundBundle(fileName)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("synchronized: not found in cache, loading: " + fileName);
                    }
                    bundle = this._loadBundle(name, fileName, loc, cacheAtStartup);
                    Locale parentLoc = loc;
                    while (bundle == null && parentLoc != null && !parentLoc.getLanguage().equals("")) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("synchronized: still not found, trying parent: " + fileName);
                        }
                        parentLoc = this.getParentLocale(parentLoc);
                        String parentBundleName = this.getFileName(name, parentLoc);
                        bundle = this._loadBundle(name, parentBundleName, parentLoc, cacheAtStartup);
                        this.updateCache(parentBundleName, bundle);
                    }
                    this.updateCache(fileName, bundle);
                }
            }
        }
        return bundle;
    }

    private XMLResourceBundle _loadBundle(String name, String fileName, Locale loc, boolean cacheAtStartup) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to load bundle: " + name + ", locale " + loc + ", filename " + fileName);
        }
        XMLResourceBundle bundle = null;
        XMLResourceBundle parentBundle = null;
        try {
            if (loc != null && !loc.getLanguage().equals("")) {
                parentBundle = (XMLResourceBundle)this.selectParent(name, loc);
            }
            bundle = new XMLResourceBundle();
            bundle.setLogger(this.logger);
            bundle.compose(this.manager);
            bundle.init(name, fileName, loc, parentBundle, cacheAtStartup);
            return bundle;
        }
        catch (FileNotFoundException fe) {
            this.logger.info("Resource not found: " + name + ", locale " + loc + ", bundleName " + fileName + ". Exception: " + fe.getMessage());
        }
        catch (SAXParseException se) {
            this.logger.error("Incorrect resource format", (Throwable)se);
        }
        catch (Exception e) {
            this.logger.error("Resource loading failed", (Throwable)e);
        }
        return null;
    }

    public void release(Component component) {
    }

    protected Locale getParentLocale(Locale loc) {
        Locale newloc = loc.getVariant().equals("") ? (loc.getCountry().equals("") ? new Locale("", "", "") : new Locale(loc.getLanguage(), "", "")) : new Locale(loc.getLanguage(), loc.getCountry(), "");
        return newloc;
    }

    protected String getFileName(String name, Locale loc) {
        StringBuffer sb = new StringBuffer(this.getDirectory());
        sb.append('/').append(name);
        if (loc != null) {
            if (!loc.getLanguage().equals("")) {
                sb.append("_");
                sb.append(loc.getLanguage());
            }
            if (!loc.getCountry().equals("")) {
                sb.append("_");
                sb.append(loc.getCountry());
            }
            if (!loc.getVariant().equals("")) {
                sb.append("_");
                sb.append(loc.getVariant());
            }
        }
        sb.append(".xml");
        String result = sb.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving bundle name to file name: " + name + ", locale " + loc + " --> " + result);
        }
        return result;
    }

    protected Component selectCached(String fileName) {
        Component bundle;
        block3: {
            bundle = null;
            try {
                bundle = super.select((Object)fileName);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Returning from cache: " + fileName);
                }
            }
            catch (ComponentException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("Not found in cache: " + fileName);
            }
        }
        return bundle;
    }

    protected boolean isNotFoundBundle(String fileName) {
        String result = (String)this.cacheNotFound.get(fileName);
        if (result != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Returning from not_found_cache: " + fileName);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Not found in not_found_cache: " + fileName);
        }
        return result != null;
    }

    protected void updateCache(String fileName, XMLResourceBundle bundle) {
        if (bundle == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Updating not_found_cache: " + fileName);
            }
            this.cacheNotFound.put(fileName, fileName);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Updating cache: " + fileName);
            }
            super.put((Object)fileName, (Component)bundle);
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean cacheAtStartup() {
        return this.cacheAtStartup;
    }

    public static class ConfigurationKeys {
        public static final String CACHE_AT_STARTUP = "cache-at-startup";
        public static final String ROOT_DIRECTORY = "catalogue-location";
    }
}

