/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.jsp.JSPEngine;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.reading.AbstractReader;

public class JSPReader
extends AbstractReader
implements Composable,
Poolable {
    private ComponentManager manager;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate() throws IOException, ProcessingException {
        if (this.source == null) {
            throw new ProcessingException("JSPReader: source JSP is not specified");
        }
        HttpServletResponse httpResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
        HttpServletRequest httpRequest = (HttpServletRequest)this.objectModel.get("httprequest");
        ServletContext httpContext = (ServletContext)this.objectModel.get("httpservletcontext");
        if (httpResponse == null || httpRequest == null || httpContext == null) {
            throw new ProcessingException("JSPReader can be used only in a Servlet/JSP environment");
        }
        JSPEngine engine = null;
        try {
            try {
                String url = this.source;
                Source src = this.resolver.resolve(url);
                System.out.println("Resolved to: " + src);
                URL resURL = httpContext.getResource(".");
                System.out.println(". resource is: " + resURL);
                if (!url.startsWith("/")) {
                    String servletPath = httpRequest.getServletPath();
                    servletPath = servletPath.substring(0, servletPath.lastIndexOf(47) + 1);
                    url = servletPath + url;
                }
                engine = (JSPEngine)this.manager.lookup("org.apache.cocoon.components.jsp.JSPEngine");
                this.getLogger().debug("JSPReader executing JSP:" + url);
                byte[] bytes = engine.executeJSP(url, httpRequest, httpResponse, httpContext);
                byte[] buffer = new byte[8192];
                int length = -1;
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                while ((length = bais.read(buffer)) > -1) {
                    this.out.write(buffer, 0, length);
                }
                bais.close();
                bais = null;
                this.out.flush();
            }
            catch (ServletException e) {
                this.getLogger().debug("ServletException in JSPReader.generate()", (Throwable)e);
                this.getLogger().debug("Embedded ServletException JSPReader.generate()", e.getRootCause());
                throw new ProcessingException("ServletException in JSPReader.generate()", e.getRootCause());
            }
            catch (IOException e) {
                this.getLogger().debug("IOException in JSPReader.generate()", (Throwable)e);
                throw new ProcessingException("IOException JSPReader.generate()", e);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                this.getLogger().debug("Exception in JSPReader.generate()", (Throwable)e);
                throw new ProcessingException("Exception JSPReader.generate()", e);
            }
            Object var13_16 = null;
            if (engine == null) return;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (engine == null) throw throwable;
            this.manager.release(engine);
            throw throwable;
        }
        this.manager.release((Component)engine);
    }
}

