/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLProtocolHandler;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.NOPCacheValidity;
import org.apache.cocoon.components.transcoder.ExtendableTranscoderFactory;
import org.apache.cocoon.components.transcoder.TranscoderFactory;
import org.apache.cocoon.components.url.ParsedContextURLProtocolHandler;
import org.apache.cocoon.components.url.ParsedResourceURLProtocolHandler;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.SVGBuilder;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SVGSerializer
extends SVGBuilder
implements Composable,
Serializer,
Configurable,
Poolable,
Cacheable,
Contextualizable {
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private ComponentManager manager = null;
    private Environment environment = null;
    private Configuration config = null;
    private OutputStream output = null;
    private String mimetype = null;
    Transcoder transcoder = null;
    TranscoderFactory factory = ExtendableTranscoderFactory.getTranscoderFactoryImplementation();

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        ParsedContextURLProtocolHandler.setContext((Context)context.get((Object)"environment-context"));
        ParsedURL.registerHandler((ParsedURLProtocolHandler)new ParsedContextURLProtocolHandler());
        ParsedURL.registerHandler((ParsedURLProtocolHandler)new ParsedResourceURLProtocolHandler());
    }

    public void setOutputStream(OutputStream out) {
        this.output = new BufferedOutputStream(out);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.mimetype = conf.getAttribute("mime-type");
        this.log.debug("SVGSerializer mime-type:" + this.mimetype);
        this.transcoder = this.factory.createTranscoder(this.mimetype);
        Configuration[] parameters = conf.getChildren("parameter");
        int i = 0;
        while (i < parameters.length) {
            String name = parameters[i].getAttribute("name");
            if ("transcoder".equals(name)) {
                String transcoderName = parameters[i].getAttribute("value");
                try {
                    this.transcoder = (Transcoder)ClassUtils.newInstance(transcoderName);
                }
                catch (Exception ex) {
                    this.log.error("Cannot load  class " + transcoderName, (Throwable)ex);
                    throw new ConfigurationException("Cannot load class " + transcoderName, (Throwable)ex);
                }
            }
            ++i;
        }
        if (this.transcoder == null) {
            throw new ConfigurationException("Could not autodetect transcoder for SVGSerializer and no transcoder was specified in the sitemap configuration.");
        }
        int i2 = 0;
        while (i2 < parameters.length) {
            String name = parameters[i2].getAttribute("name");
            if (!"transcoder".equals(name)) {
                try {
                    Object value;
                    name = ("KEY_" + name).toUpperCase();
                    TranscodingHints.Key key = (TranscodingHints.Key)this.transcoder.getClass().getField(name).get(this.transcoder);
                    String keyType = parameters[i2].getAttribute("type", "STRING").toUpperCase();
                    if ("FLOAT".equals(keyType)) {
                        value = new Float(parameters[i2].getAttributeAsFloat("value"));
                    } else if ("INTEGER".equals(keyType)) {
                        value = new Integer(parameters[i2].getAttributeAsInteger("value"));
                    } else if ("BOOLEAN".equals(keyType)) {
                        value = new Boolean(parameters[i2].getAttributeAsBoolean("value"));
                    } else if ("COLOR".equals(keyType)) {
                        String stringValue = parameters[i2].getAttribute("value");
                        if (stringValue.startsWith("#")) {
                            stringValue = stringValue.substring(1);
                        }
                        value = new Color(Integer.parseInt(stringValue, 16));
                    } else {
                        value = parameters[i2].getValue("");
                    }
                    this.log.debug("SVG Serializer: adding hint \"" + name + "\" with value \"" + value.toString() + "\"");
                    this.transcoder.addTranscodingHint(key, value);
                }
                catch (ClassCastException ex) {
                    throw new ConfigurationException("Specified key (" + name + ") is not a valid Batik Transcoder key.", (Throwable)ex);
                }
                catch (ConfigurationException ex) {
                    throw new ConfigurationException("Name or value not specified.", (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new ConfigurationException("Cannot access the key for parameter \"" + name + "\"", (Throwable)ex);
                }
                catch (NoSuchFieldException ex) {
                    throw new ConfigurationException("No field available for parameter \"" + name + "\"", (Throwable)ex);
                }
            }
            ++i2;
        }
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void setConsumer(XMLConsumer consumer) {
        this.contentHandler = consumer;
        this.lexicalHandler = consumer;
    }

    public void setContentHandler(ContentHandler content) {
        this.contentHandler = content;
    }

    public void setLexicalHandler(LexicalHandler lexical) {
        this.lexicalHandler = lexical;
    }

    public void notify(Document doc) throws SAXException {
        try {
            TranscoderInput transInput = new TranscoderInput(doc);
            TranscoderOutput transOutput = new TranscoderOutput(this.output);
            this.transcoder.transcode(transInput, transOutput);
        }
        catch (Exception ex) {
            this.log.error("SVGSerializer: Exception writing image", (Throwable)ex);
            throw new SAXException("Exception writing image ", ex);
        }
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public long generateKey() {
        return 1L;
    }

    public CacheValidity generateValidity() {
        return NOPCacheValidity.CACHE_VALIDITY;
    }

    public boolean shouldSetContentLength() {
        return false;
    }
}

