/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.logger.DefaultLogKitManager;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.notification.DefaultNotifyingBuilder;
import org.apache.cocoon.components.notification.Notifier;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.SimpleNotifyingBean;
import org.apache.cocoon.components.request.RequestFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.http.HttpContext;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.StringUtils;
import org.apache.cocoon.util.log.CocoonLogFormatter;
import org.apache.log.ContextMap;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.ServletOutputLogTarget;

public class CocoonServlet
extends HttpServlet {
    protected static final String PROCESSED_BY = "Processed by Apache Cocoon 2.0.4 in ";
    protected Logger log;
    protected LogKitManager logKitManager;
    static final float SECOND = 1000.0f;
    static final float MINUTE = 60000.0f;
    static final float HOUR = 3600000.0f;
    protected long creationTime = 0L;
    protected Cocoon cocoon;
    protected Exception exception;
    protected DefaultContext appContext = new DefaultContext();
    protected boolean allowReload;
    protected boolean showTime;
    protected boolean hiddenShowTime;
    private static final boolean SAVE_UPLOADS_TO_DISK = true;
    private static final int MAX_UPLOAD_SIZE = 10000000;
    private int maxUploadSize;
    private boolean autoSaveUploads;
    private boolean allowOverwrite;
    private boolean silentlyRename;
    private File uploadDir;
    private File workDir;
    private File cacheDir;
    private String containerEncoding;
    private String defaultFormEncoding;
    protected ServletContext servletContext;
    protected ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    protected boolean initClassLoader = false;
    private String parentComponentManagerClass;
    protected String forceLoadParameter;
    protected String forceSystemProperty;
    private boolean manageExceptions;
    protected String servletContextPath;
    protected URL servletContextURL;
    protected RequestFactory requestFactory;
    static /* synthetic */ Class class$java$lang$String;

    public void init(ServletConfig conf) throws ServletException {
        String cacheDirParam;
        String value;
        super.init(conf);
        String initClassLoaderParam = conf.getInitParameter("init-classloader");
        boolean bl = this.initClassLoader = "true".equalsIgnoreCase(initClassLoaderParam) || "yes".equalsIgnoreCase(initClassLoaderParam);
        if (this.initClassLoader) {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value = System.getProperty("javax.xml.parsers.SAXParserFactory")) != null && value.startsWith("weblogic")) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        }
        this.servletContext = conf.getServletContext();
        this.appContext.put((Object)"environment-context", (Object)new HttpContext(this.servletContext));
        this.servletContextPath = this.servletContext.getRealPath("/");
        String workDirParam = conf.getInitParameter("work-directory");
        if (workDirParam != null && !workDirParam.trim().equals("")) {
            File workDirParamFile;
            this.workDir = this.servletContextPath == null ? new File(workDirParam) : ((workDirParamFile = new File(workDirParam)).isAbsolute() ? workDirParamFile : new File(this.servletContextPath, workDirParam));
        } else {
            this.workDir = (File)this.servletContext.getAttribute("javax.servlet.context.tempdir");
            this.workDir = new File(this.workDir, "cocoon-files");
        }
        this.workDir.mkdirs();
        this.initLogger();
        String path = this.servletContextPath;
        if (this.log.isDebugEnabled()) {
            this.log.debug("getRealPath for /: " + path);
        }
        if (path == null) {
            try {
                path = this.servletContext.getResource("/WEB-INF").toString();
            }
            catch (MalformedURLException me) {
                throw new ServletException("Unable to get resource 'WEB-INF'.", (Throwable)me);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("getResource for /WEB-INF: " + path);
            }
            path = path.substring(0, path.length() - "WEB-INF".length());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Path for Root: " + path);
            }
        }
        try {
            this.servletContextURL = path.indexOf(58) > 1 ? new URL(path) : new File(path).toURL();
        }
        catch (MalformedURLException me) {
            try {
                this.servletContextURL = new File(path).toURL();
            }
            catch (MalformedURLException ignored) {
                throw new ServletException("Unable to determine servlet context URL.", (Throwable)me);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("URL for Root: " + this.servletContextURL);
        }
        this.forceLoadParameter = conf.getInitParameter("load-class");
        if (conf.getInitParameter("load-class") == null && this.log.isDebugEnabled()) {
            this.log.debug("load-class was not set - defaulting to false?");
        }
        this.forceSystemProperty = conf.getInitParameter("force-property");
        if (workDirParam != null && !workDirParam.trim().equals("")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using work-directory " + this.workDir);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("work-directory was not set - defaulting to " + this.workDir);
        }
        this.appContext.put((Object)"work-directory", (Object)this.workDir);
        String uploadDirParam = conf.getInitParameter("upload-directory");
        if (uploadDirParam != null && !uploadDirParam.trim().equals("")) {
            File uploadDirParamFile;
            this.uploadDir = this.servletContextPath == null ? new File(uploadDirParam) : ((uploadDirParamFile = new File(uploadDirParam)).isAbsolute() ? uploadDirParamFile : new File(this.servletContextPath, uploadDirParam));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using upload-directory " + this.uploadDir);
            }
        } else {
            this.uploadDir = new File(this.workDir, "upload-dir" + File.separator);
            if (this.log.isDebugEnabled()) {
                this.log.debug("upload-directory was not set - defaulting to " + this.uploadDir);
            }
        }
        this.uploadDir.mkdirs();
        this.appContext.put((Object)"upload-directory", (Object)this.uploadDir);
        value = conf.getInitParameter("autosave-uploads");
        if (value != null) {
            this.autoSaveUploads = "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
        } else {
            this.autoSaveUploads = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("autosave-uploads was not set - defaulting to " + this.autoSaveUploads);
            }
        }
        String overwriteParam = conf.getInitParameter("overwrite-uploads");
        if (overwriteParam == null && this.log.isDebugEnabled()) {
            this.log.debug("overwrite-uploads was not set - defaulting to rename");
        }
        if ("deny".equalsIgnoreCase(overwriteParam)) {
            this.allowOverwrite = false;
            this.silentlyRename = false;
        } else if ("allow".equalsIgnoreCase(overwriteParam)) {
            this.allowOverwrite = true;
            this.silentlyRename = false;
        } else {
            this.allowOverwrite = false;
            this.silentlyRename = true;
        }
        this.maxUploadSize = 10000000;
        String maxSizeParam = conf.getInitParameter("upload-max-size");
        if (maxSizeParam != null && !maxSizeParam.trim().equals("")) {
            this.maxUploadSize = Integer.parseInt(maxSizeParam);
        }
        if ((cacheDirParam = conf.getInitParameter("cache-directory")) != null && !cacheDirParam.trim().equals("")) {
            File cacheDirParamFile;
            this.cacheDir = this.servletContextPath == null ? new File(cacheDirParam) : ((cacheDirParamFile = new File(cacheDirParam)).isAbsolute() ? cacheDirParamFile : new File(this.servletContextPath, cacheDirParam));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using cache-directory " + this.cacheDir);
            }
        } else {
            this.cacheDir = IOUtils.createFile(this.workDir, "cache-dir" + File.separator);
            if (this.log.isDebugEnabled()) {
                this.log.debug("cache-directory was not set - defaulting to " + this.cacheDir);
            }
        }
        this.cacheDir.mkdirs();
        this.appContext.put((Object)"cache-directory", (Object)this.cacheDir);
        this.appContext.put((Object)"config-url", (Object)this.getConfigFile(conf.getInitParameter("configurations")));
        if (conf.getInitParameter("configurations") == null && this.log.isDebugEnabled()) {
            this.log.debug("configurations was not set - defaulting to... ?");
        }
        boolean bl2 = this.allowReload = (value = conf.getInitParameter("allow-reload")) == null || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
        if (value == null && this.log.isDebugEnabled()) {
            this.log.debug("allow-reload was not set - defaulting to true");
        }
        boolean bl3 = this.showTime = "yes".equalsIgnoreCase(value = conf.getInitParameter("show-time")) || "true".equalsIgnoreCase(value) || (this.hiddenShowTime = "hide".equals(value));
        if (value == null && this.log.isDebugEnabled()) {
            this.log.debug("show-time was not set - defaulting to false");
        }
        this.parentComponentManagerClass = conf.getInitParameter("parent-component-manager");
        if (this.parentComponentManagerClass == null && this.log.isDebugEnabled()) {
            this.log.debug("parent-component-manager was not set - defaulting to null.");
        }
        if ((value = conf.getInitParameter("request-factory")) == null) {
            value = "org.apache.cocoon.components.request.MultipartRequestFactoryImpl";
            if (this.log.isDebugEnabled()) {
                this.log.debug("request-factory was not set - defaulting to " + value);
            }
        }
        this.requestFactory = RequestFactory.getRequestFactory(value);
        this.containerEncoding = conf.getInitParameter("container-encoding");
        if (this.containerEncoding == null) {
            this.containerEncoding = "ISO-8859-1";
            if (this.log.isDebugEnabled()) {
                this.log.debug("container-encoding was not set - defaulting to ISO-8859-1.");
            }
        }
        this.defaultFormEncoding = conf.getInitParameter("form-encoding");
        if (this.defaultFormEncoding == null && this.log.isDebugEnabled()) {
            this.log.debug("form-encoding was not set - defaulting to null.");
        }
        boolean bl4 = this.manageExceptions = (value = conf.getInitParameter("manage-exceptions")) == null || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
        if (value == null && this.log.isDebugEnabled()) {
            this.log.debug("Parameter manageExceptions was not set - defaulting to true.");
        }
        this.createCocoon();
    }

    public void destroy() {
        if (this.initClassLoader) {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cocoon != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Servlet destroyed - disposing Cocoon");
            }
            this.disposeCocoon();
        }
    }

    protected void addClassLoaderURL(URL URL2) {
    }

    protected void addClassLoaderDirectory(String dir) {
    }

    protected String getClassPath() throws ServletException {
        StringBuffer buildClassPath = new StringBuffer();
        File root = null;
        if (this.servletContextPath != null) {
            String classDir = this.servletContext.getRealPath("/WEB-INF/classes");
            String libDir = this.servletContext.getRealPath("/WEB-INF/lib");
            if (libDir != null) {
                root = new File(libDir);
            }
            if (classDir != null) {
                buildClassPath.append(classDir);
                this.addClassLoaderDirectory(classDir);
            }
        } else {
            URL libDirURL;
            URL classDirURL;
            block14: {
                block13: {
                    classDirURL = null;
                    libDirURL = null;
                    try {
                        classDirURL = this.servletContext.getResource("/WEB-INF/classes");
                    }
                    catch (MalformedURLException me) {
                        if (!this.log.isWarnEnabled()) break block13;
                        this.log.warn("Unable to add WEB-INF/classes to the classpath", (Throwable)me);
                    }
                }
                try {
                    libDirURL = this.servletContext.getResource("/WEB-INF/lib");
                }
                catch (MalformedURLException me) {
                    if (!this.log.isWarnEnabled()) break block14;
                    this.log.warn("Unable to add WEB-INF/lib to the classpath", (Throwable)me);
                }
            }
            if (libDirURL != null && libDirURL.toExternalForm().startsWith("file:")) {
                root = new File(libDirURL.toExternalForm().substring("file:".length()));
            }
            if (classDirURL != null) {
                buildClassPath.append(classDirURL.toExternalForm());
                this.addClassLoaderURL(classDirURL);
            }
        }
        if (root == null) {
            root = this.extractLibraries();
        }
        if (root != null && root.isDirectory()) {
            Object[] libraries = root.listFiles();
            Arrays.sort(libraries);
            int i = 0;
            while (i < libraries.length) {
                String fullName = IOUtils.getFullFilename((File)libraries[i]);
                buildClassPath.append(File.pathSeparatorChar).append(fullName);
                this.addClassLoaderDirectory(fullName);
                ++i;
            }
        }
        buildClassPath.append(File.pathSeparatorChar).append(System.getProperty("java.class.path"));
        buildClassPath.append(File.pathSeparatorChar).append(this.getExtraClassPath());
        return buildClassPath.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File extractLibraries() {
        try {
            URL manifestURL = this.servletContext.getResource("/META-INF/MANIFEST.MF");
            if (manifestURL == null) {
                this.log.fatalError("Unable to get Manifest");
                return null;
            }
            Manifest mf = new Manifest(manifestURL.openStream());
            Attributes attr = mf.getMainAttributes();
            String libValue = attr.getValue("Cocoon-Libs");
            if (libValue == null) {
                this.log.fatalError("Unable to get 'Cocoon-Libs' attribute from the Manifest");
                return null;
            }
            ArrayList<String> libList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(libValue, " ");
            while (true) {
                if (!st.hasMoreTokens()) break;
                libList.add(st.nextToken());
            }
            File root = new File(this.workDir, "lib");
            root.mkdirs();
            File[] oldLibs = root.listFiles();
            int i = 0;
            while (true) {
                if (i >= oldLibs.length) break;
                String oldLib = oldLibs[i].getName();
                if (!libList.contains(oldLib)) {
                    this.log.debug("Removing old library " + oldLibs[i]);
                    oldLibs[i].delete();
                }
                ++i;
            }
            this.log.warn("Extracting libraries into " + root);
            byte[] buffer = new byte[65536];
            Iterator i2 = libList.iterator();
            while (true) {
                InputStream is;
                if (!i2.hasNext()) {
                    return root;
                }
                String libName = (String)i2.next();
                long lastModified = -1L;
                try {
                    lastModified = Long.parseLong(attr.getValue("Cocoon-Lib-" + libName.replace('.', '_')));
                }
                catch (Exception e) {
                    this.log.debug("Failed to parse lastModified: " + attr.getValue("Cocoon-Lib-" + libName.replace('.', '_')));
                }
                File lib = new File(root, libName);
                if (lib.exists() && lib.lastModified() != lastModified) {
                    this.log.debug("Removing modified library " + lib);
                    lib.delete();
                }
                if ((is = this.servletContext.getResourceAsStream("/WEB-INF/lib/" + libName)) == null) {
                    this.log.warn("Skipping " + libName);
                } else {
                    FileOutputStream os;
                    block21: {
                        Object var20_20;
                        this.log.debug("Extracting " + libName);
                        os = null;
                        try {
                            os = new FileOutputStream(lib);
                            while (true) {
                                void var18_19;
                                int count;
                                if ((count = is.read(buffer)) <= 0) {
                                    var20_20 = null;
                                    if (is == null) break block21;
                                    break;
                                }
                                ((OutputStream)os).write(buffer, 0, (int)var18_19);
                            }
                        }
                        catch (Throwable throwable) {
                            var20_20 = null;
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                ((OutputStream)os).close();
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                if (lastModified == -1L) continue;
                lib.setLastModified(lastModified);
            }
        }
        catch (IOException e) {
            this.log.fatalError("Exception while processing Manifest file", (Throwable)e);
            return null;
        }
    }

    protected String getExtraClassPath() throws ServletException {
        String extraClassPath = this.getInitParameter("extra-classpath");
        if (extraClassPath != null && !extraClassPath.trim().equals("")) {
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(extraClassPath, System.getProperty("path.separator"), false);
            int i = 0;
            while (st.hasMoreTokens()) {
                String path;
                String s = st.nextToken();
                if (i++ > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                if (s.charAt(0) == File.separatorChar || s.charAt(1) == ':') {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("extraClassPath is absolute: " + s);
                    }
                    sb.append(s);
                    this.addClassLoaderDirectory(s);
                    continue;
                }
                if (s.indexOf("${") != -1) {
                    path = StringUtils.replaceToken(s);
                    sb.append(path);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("extraClassPath is not absolute replacing using token: [" + s + "] : " + path);
                    }
                    this.addClassLoaderDirectory(path);
                    continue;
                }
                path = null;
                if (this.servletContextPath != null) {
                    path = this.servletContextPath + s;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("extraClassPath is not absolute pre-pending context path: " + path);
                    }
                } else {
                    path = this.workDir.toString() + s;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("extraClassPath is not absolute pre-pending work-directory: " + path);
                    }
                }
                sb.append(path);
                this.addClassLoaderDirectory(path);
            }
            return sb.toString();
        }
        return "";
    }

    private void initLogger() {
        String logLevel = this.getInitParameter("log-level");
        if (logLevel == null) {
            logLevel = "INFO";
        }
        String accesslogger = this.getInitParameter("servlet-logger");
        Priority logPriority = Priority.getPriorityForName((String)logLevel.trim());
        ServletOutputLogTarget servTarget = new ServletOutputLogTarget(this.servletContext);
        CocoonLogFormatter formatter = new CocoonLogFormatter();
        formatter.setFormat("%7.7{priority} %{time}   [%8.8{category}] (%{uri}) %{thread}/%{class:short}: %{message}\\n%{throwable}");
        servTarget.setFormatter((Formatter)formatter);
        Hierarchy.getDefaultHierarchy().setDefaultLogTarget((LogTarget)servTarget);
        Hierarchy.getDefaultHierarchy().setDefaultPriority(logPriority);
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor("");
        DefaultLogKitManager logKitManager = new DefaultLogKitManager(Hierarchy.getDefaultHierarchy());
        logKitManager.setLogger(logger);
        DefaultContext subcontext = new DefaultContext((Context)this.appContext);
        subcontext.put((Object)"servlet-context", (Object)this.servletContext);
        if (this.servletContextPath == null) {
            File logSCDir = new File(this.workDir, "log");
            logSCDir.mkdirs();
            if (logger.isWarnEnabled()) {
                logger.warn("Setting servlet-context for LogKit to " + logSCDir);
            }
            subcontext.put((Object)"context-root", (Object)logSCDir.toString());
        } else {
            subcontext.put((Object)"context-root", (Object)this.servletContextPath);
        }
        try {
            logKitManager.contextualize((Context)subcontext);
            this.logKitManager = logKitManager;
            String logkitConfig = this.getInitParameter("logkit-config");
            if (logkitConfig == null) {
                logkitConfig = "/WEB-INF/logkit.xconf";
            }
            InputStream is = this.servletContext.getResourceAsStream(logkitConfig);
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            Configuration conf = builder.build(is);
            logKitManager.configure(conf);
        }
        catch (Exception e) {
            Hierarchy.getDefaultHierarchy().log("Could not set up Cocoon Logger, will use screen instead", (Throwable)e);
        }
        this.log = accesslogger != null ? logKitManager.getLogger(accesslogger) : logKitManager.getLogger("cocoon");
    }

    private URL getConfigFile(String configFileName) throws ServletException {
        URL result;
        String usedFileName;
        if (configFileName == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Servlet initialization argument 'configurations' not specified, attempting to use '/WEB-INF/cocoon.xconf'");
            }
            usedFileName = "/WEB-INF/cocoon.xconf";
        } else {
            usedFileName = configFileName;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using configuration file: " + usedFileName);
        }
        try {
            result = this.servletContext.getResource(usedFileName);
        }
        catch (Exception mue) {
            String msg = "Init parameter 'configurations' is invalid : " + usedFileName;
            this.log.error(msg, (Throwable)mue);
            throw new ServletException(msg, (Throwable)mue);
        }
        if (result == null) {
            String msg = "Init parameter 'configuration' doesn't name an existing resource : " + usedFileName;
            this.log.error(msg);
            throw new ServletException(msg);
        }
        return result;
    }

    private void forceLoad() {
        if (this.forceLoadParameter != null) {
            StringTokenizer fqcnTokenizer = new StringTokenizer(this.forceLoadParameter, " \t\r\n\f;,", false);
            while (fqcnTokenizer.hasMoreTokens()) {
                String fqcn = fqcnTokenizer.nextToken().trim();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Trying to load class: " + fqcn);
                    }
                    ClassUtils.loadClass(fqcn).newInstance();
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Could not force-load class: " + fqcn, (Throwable)e);
                }
            }
        }
    }

    private void forceProperty() {
        if (this.forceSystemProperty != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.forceSystemProperty, " \t\r\n\f;,", false);
            Properties systemProps = System.getProperties();
            while (tokenizer.hasMoreTokens()) {
                String property = tokenizer.nextToken().trim();
                if (property.indexOf(61) == -1) continue;
                try {
                    String key = property.substring(0, property.indexOf(61));
                    String value = property.substring(property.indexOf(61) + 1);
                    if (value.indexOf("${") != -1) {
                        value = StringUtils.replaceToken(value);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("setting " + key + "=" + value);
                    }
                    systemProps.setProperty(key, value);
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Could not set property: " + property, (Throwable)e);
                }
            }
            System.setProperties(systemProps);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block45: {
            block43: {
                block44: {
                    if (this.initClassLoader) {
                        try {
                            Thread.currentThread().setContextClassLoader(this.classLoader);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    start = System.currentTimeMillis();
                    res.addHeader("X-Cocoon-Version", "2.0.4");
                    request = this.requestFactory.getServletRequest(req, this.autoSaveUploads, this.uploadDir, this.allowOverwrite, this.silentlyRename, this.maxUploadSize);
                    this.cocoon = this.getCocoon(request.getPathInfo(), request.getParameter("cocoon-reload"));
                    if (this.cocoon == null) {
                        if (this.manageExceptions) {
                            res.reset();
                            n = new SimpleNotifyingBean((Object)this);
                            n.setType("fatal");
                            n.setTitle("Internal servlet error");
                            n.setSource("Cocoon servlet");
                            n.setMessage("Cocoon was not initialized.");
                            n.setDescription("Cocoon was not initialized. Cannot process request.");
                            n.addExtraDescription("request-uri", request.getRequestURI());
                            res.setContentType("text/html");
                            res.setStatus(500);
                            Notifier.notify((Notifying)n, (OutputStream)res.getOutputStream(), "text/html");
                            return;
                        }
                        res.sendError(500, "The Cocoon engine said it failed to process the request for an unknown reason.");
                        res.flushBuffer();
                        return;
                    }
                    uri = request.getServletPath();
                    if (uri == null) {
                        uri = "";
                    }
                    if ((pathInfo = request.getPathInfo()) != null) {
                        if (uri.length() > 0 && uri.charAt(0) == '/') {
                            uri = uri.substring(1);
                        }
                        uri = uri + pathInfo;
                    }
                    if (uri.length() == 0) {
                        prefix = request.getRequestURI();
                        if (prefix == null) {
                            prefix = "";
                        }
                        res.sendRedirect(res.encodeRedirectURL(prefix + "/"));
                        return;
                    }
                    contentType = null;
                    ctxMap = null;
                    try {
                        block42: {
                            try {
                                if (uri.charAt(0) == '/') {
                                    uri = uri.substring(1);
                                }
                                env = this.getEnvironment(URLDecoder.decode(uri), request, res);
                                ctxMap = ContextMap.getCurrentContext();
                                threadName = Thread.currentThread().getName();
                                ctxMap.set("threadName", (Object)threadName);
                                ctxMap.set("objectModel", (Object)env.getObjectModel());
                                ctxMap.set("request-id", (Object)(threadName + System.currentTimeMillis()));
                                if (this.cocoon.process(env)) {
                                    contentType = env.getContentType();
                                    break block42;
                                }
                                this.log.fatalError("The Cocoon engine said it failed to process the request for an unknown reason.");
                                if (this.manageExceptions) {
                                    res.reset();
                                    n = new SimpleNotifyingBean((Object)this);
                                    n.setType("error");
                                    n.setTitle("Cocoon confusion");
                                    n.setSource("Cocoon servlet");
                                    n.setMessage("Cocoon engine failed in process.");
                                    n.setDescription("The Cocoon engine said it failed to process the request for an unknown reason.");
                                    n.addExtraDescription("request-uri", request.getRequestURI());
                                    n.addExtraDescription("path-info", uri);
                                    res.setContentType("text/html");
                                    res.setStatus(500);
                                    Notifier.notify((Notifying)n, (OutputStream)res.getOutputStream(), "text/html");
                                } else {
                                    res.sendError(500, "The Cocoon engine said it failed to process the request for an unknown reason.");
                                    res.flushBuffer();
                                }
                                var18_21 = null;
                                if (ctxMap == null) break block43;
                                break block44;
                            }
                            catch (ResourceNotFoundException rse) {
                                if (this.log.isWarnEnabled()) {
                                    this.log.warn("The resource was not found", (Throwable)rse);
                                }
                                if (this.manageExceptions) {
                                    res.reset();
                                    n = new SimpleNotifyingBean((Object)this);
                                    n.setType("resource-not-found");
                                    n.setTitle("Resource not found");
                                    n.setSource("Cocoon servlet");
                                    n.setMessage("Resource not found");
                                    n.setDescription("The requested URI \"" + request.getRequestURI() + "\" was not found.");
                                    n.addExtraDescription("request-uri", request.getRequestURI());
                                    n.addExtraDescription("path-info", uri);
                                    res.setContentType("text/html");
                                    res.setStatus(404);
                                    Notifier.notify((Notifying)n, (OutputStream)res.getOutputStream(), "text/html");
                                } else {
                                    res.sendError(404, "Resource not found.");
                                    res.flushBuffer();
                                }
                                var18_22 = null;
                                if (ctxMap != null) {
                                    ctxMap.clear();
                                }
                                try {
                                    out = res.getOutputStream();
                                    out.flush();
                                    out.close();
                                    return;
                                }
                                catch (Exception e) {
                                    this.log.error("Cocoon servlet threw an Exception while trying to close stream.", (Throwable)e);
                                }
                                return;
                            }
                            catch (ConnectionResetException cre) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("The connection was reset", (Throwable)cre);
                                }
                                if (this.log.isWarnEnabled()) {
                                    this.log.warn("The connection was reset.");
                                }
                            }
                            catch (Exception e) {
                                if (this.log.isErrorEnabled()) {
                                    this.log.error("Problem with Cocoon servlet", (Throwable)e);
                                }
                                if (this.manageExceptions) {
                                    res.reset();
                                    extraDescriptions = new HashMap<String, String>(3);
                                    extraDescriptions.put("request-uri", request.getRequestURI());
                                    extraDescriptions.put("path-info", uri);
                                    writer = new StringWriter();
                                    e.printStackTrace(new PrintWriter(writer));
                                    extraDescriptions.put("stack-trace", writer.toString());
                                    n = new DefaultNotifyingBuilder().build((Object)this, e, "fatal", "Internal server error", "Cocoon servlet", null, null, extraDescriptions);
                                    res.setContentType("text/html");
                                    res.setStatus(500);
                                    Notifier.notify(n, (OutputStream)res.getOutputStream(), "text/html");
                                } else {
                                    res.sendError(500, "Internal server error.");
                                    res.flushBuffer();
                                }
                                var18_23 = null;
                                if (ctxMap != null) {
                                    ctxMap.clear();
                                }
                                ** try [egrp 3[TRYBLOCK] [5 : 1328->1349)] { 
lbl141:
                                // 1 sources

                                out = res.getOutputStream();
                                out.flush();
                                out.close();
                                return;
lbl145:
                                // 1 sources

                                catch (Exception e) {
                                    this.log.error("Cocoon servlet threw an Exception while trying to close stream.", (Throwable)e);
                                }
                                return;
                            }
                        }
                        end = System.currentTimeMillis();
                        timeString = this.processTime(end - start);
                        if (this.log.isInfoEnabled()) {
                            this.log.info("'" + uri + "' " + timeString);
                        }
                        if (contentType == null || !contentType.equals("text/html")) break block45;
                        showTime = request.getParameter("cocoon-showtime");
                        show = this.showTime;
                        if (showTime != null) {
                            v0 = show = showTime.equalsIgnoreCase("no") == false;
                        }
                        if (show) {
                            hide = this.hiddenShowTime;
                            if (showTime != null) {
                                hide = showTime.equalsIgnoreCase("hide");
                            }
                            out = res.getOutputStream();
                            out.print(hide != false ? "<!-- " : "<p>");
                            out.print(timeString);
                            out.println(hide != false ? " -->" : "</p>");
                        }
                        break block45;
                    }
                    catch (Throwable var17_43) {
                        var18_25 = null;
                        if (ctxMap != null) {
                            ctxMap.clear();
                        }
                        ** try [egrp 3[TRYBLOCK] [5 : 1328->1349)] { 
lbl174:
                        // 1 sources

                        out = res.getOutputStream();
                        out.flush();
                        out.close();
                        throw var17_43;
lbl178:
                        // 1 sources

                        catch (Exception e) {
                            this.log.error("Cocoon servlet threw an Exception while trying to close stream.", (Throwable)e);
                        }
                        throw var17_43;
                    }
                }
                ctxMap.clear();
            }
            ** try [egrp 3[TRYBLOCK] [5 : 1328->1349)] { 
lbl185:
            // 1 sources

            out = res.getOutputStream();
            out.flush();
            out.close();
            return;
lbl189:
            // 1 sources

            catch (Exception e) {
                this.log.error("Cocoon servlet threw an Exception while trying to close stream.", (Throwable)e);
            }
            return;
        }
        var18_24 = null;
        if (ctxMap != null) {
            ctxMap.clear();
        }
        try {}
        catch (Exception e) {
            this.log.error("Cocoon servlet threw an Exception while trying to close stream.", (Throwable)e);
            return;
        }
        out = res.getOutputStream();
        out.flush();
        out.close();
    }

    protected Environment getEnvironment(String uri, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String formEncoding = req.getParameter("cocoon-form-encoding");
        if (formEncoding == null) {
            formEncoding = this.defaultFormEncoding;
        }
        HttpEnvironment env = new HttpEnvironment(uri, this.servletContextURL, req, res, this.servletContext, (HttpContext)this.appContext.get((Object)"environment-context"), this.containerEncoding, formEncoding, this.requestFactory);
        env.setLogger(this.log);
        return env;
    }

    private synchronized ComponentManager getParentComponentManager() {
        ComponentManager parentComponentManager;
        block7: {
            parentComponentManager = null;
            if (this.parentComponentManagerClass != null) {
                try {
                    String initParam = null;
                    int dividerPos = this.parentComponentManagerClass.indexOf(47);
                    if (dividerPos != -1) {
                        initParam = this.parentComponentManagerClass.substring(dividerPos + 1);
                        this.parentComponentManagerClass = this.parentComponentManagerClass.substring(0, dividerPos);
                    }
                    Class pcm = ClassUtils.loadClass(this.parentComponentManagerClass);
                    Constructor pcmc = pcm.getConstructor(class$java$lang$String == null ? (class$java$lang$String = CocoonServlet.class$("java.lang.String")) : class$java$lang$String);
                    parentComponentManager = (ComponentManager)pcmc.newInstance(initParam);
                    if (parentComponentManager instanceof Loggable) {
                        ((Loggable)parentComponentManager).setLogger(this.log);
                    }
                    if (parentComponentManager instanceof Contextualizable) {
                        ((Contextualizable)parentComponentManager).contextualize((Context)this.appContext);
                    }
                    if (parentComponentManager instanceof Initializable) {
                        ((Initializable)parentComponentManager).initialize();
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block7;
                    this.log.error("Could not initialize parent component manager.", (Throwable)e);
                }
            }
        }
        return parentComponentManager;
    }

    private synchronized void createCocoon() throws ServletException {
        if (this.initClassLoader) {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.updateEnvironment();
        this.forceLoad();
        this.forceProperty();
        try {
            URL configFile = (URL)this.appContext.get((Object)"config-url");
            if (this.log.isInfoEnabled()) {
                this.log.info("Reloading from: " + configFile.toExternalForm());
            }
            Cocoon c = (Cocoon)ClassUtils.newInstance("org.apache.cocoon.Cocoon");
            String rootlogger = this.getInitParameter("cocoon-logger");
            if (rootlogger != null) {
                c.setLogger(this.logKitManager.getLogger(rootlogger));
            } else {
                c.setLogger(this.log);
            }
            c.contextualize((Context)this.appContext);
            c.compose(this.getParentComponentManager());
            c.setLogKitManager(this.logKitManager);
            c.initialize();
            this.creationTime = System.currentTimeMillis();
            this.disposeCocoon();
            this.cocoon = c;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Exception reloading", (Throwable)e);
            }
            this.exception = e;
            this.disposeCocoon();
        }
    }

    protected void updateEnvironment() throws ServletException {
        this.appContext.put((Object)"class-loader", (Object)this.classLoader);
        this.appContext.put((Object)"classpath", (Object)this.getClassPath());
    }

    private String processTime(long time) {
        StringBuffer out = new StringBuffer(PROCESSED_BY);
        if ((float)time <= 1000.0f) {
            out.append(time);
            out.append(" milliseconds.");
        } else if ((float)time <= 60000.0f) {
            out.append((float)time / 1000.0f);
            out.append(" seconds.");
        } else if ((float)time <= 3600000.0f) {
            out.append((float)time / 60000.0f);
            out.append(" minutes.");
        } else {
            out.append((float)time / 3600000.0f);
            out.append(" hours.");
        }
        return out.toString();
    }

    private Cocoon getCocoon(String pathInfo, String reloadParam) throws ServletException {
        if (this.cocoon != null && this.allowReload) {
            if (this.cocoon.modifiedSince(this.creationTime)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Configuration changed reload attempt");
                }
                this.initLogger();
                this.createCocoon();
                return this.cocoon;
            }
            if (pathInfo == null && reloadParam != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Forced reload attempt");
                }
                this.initLogger();
                this.createCocoon();
                return this.cocoon;
            }
        } else if (pathInfo == null && this.allowReload && reloadParam != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Invalid configurations reload");
            }
            this.initLogger();
            this.createCocoon();
            return this.cocoon;
        }
        return this.cocoon;
    }

    private final void disposeCocoon() {
        if (this.cocoon != null) {
            this.cocoon.dispose();
            this.cocoon = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

