/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import org.xml.sax.SAXException;

public class NamespacesTable {
    private Entry entry = Entry.access$000("", "");

    public NamespacesTable() {
        this.entry.previousDeclaration = this.entry;
        this.addDeclaration("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public Declaration addDeclaration(String prefix, String uri) {
        Entry e = Entry.create(prefix, uri);
        Entry previous = null;
        Entry current = this.entry;
        while (current != null) {
            if (current.prefixHash == e.prefixHash) {
                e.previousDeclaration = current;
                e.nextEntry = current.nextEntry;
                current.nextEntry = null;
                if (previous == null) {
                    this.entry = e;
                } else {
                    previous.nextEntry = e;
                }
                return e;
            }
            previous = current;
            current = current.nextEntry;
        }
        if (previous == null) {
            this.entry = e;
        } else {
            previous.nextEntry = e;
        }
        return e;
    }

    public Declaration removeDeclaration(String prefix) {
        int hash = prefix.hashCode();
        Entry previous = null;
        Entry current = this.entry;
        while (current != null) {
            if (current.prefixHash == hash) {
                if (current.previousDeclaration == null) {
                    if (previous == null) {
                        this.entry = current.nextEntry;
                    } else {
                        previous.nextEntry = current.nextEntry;
                    }
                } else {
                    current.previousDeclaration.nextEntry = current.nextEntry;
                    if (previous == null) {
                        this.entry = current.previousDeclaration;
                    } else {
                        previous.nextEntry = current.previousDeclaration;
                    }
                }
                return current;
            }
            previous = current;
            current = current.nextEntry;
        }
        return null;
    }

    public String getUri(String prefix) {
        int hash = prefix.hashCode();
        Entry current = this.entry;
        while (current != null) {
            if (current.prefixHash == hash) {
                return current.uri;
            }
            current = current.nextEntry;
        }
        return null;
    }

    public String[] getPrefixes(String uri) {
        int hash = uri.hashCode();
        Entry current = this.entry;
        int count = 0;
        while (current != null) {
            if (current.uriHash == hash) {
                ++count;
            }
            current = current.nextEntry;
        }
        if (count == 0) {
            return new String[0];
        }
        String[] prefixes = new String[count];
        count = 0;
        while (current != null) {
            if (current.uriHash == hash) {
                prefixes[count++] = current.prefix;
            }
            current = current.nextEntry;
        }
        return prefixes;
    }

    public String getPrefix(String uri) {
        int hash = uri.hashCode();
        Entry current = this.entry;
        while (current != null) {
            if (current.uriHash == hash) {
                return current.prefix;
            }
            current = current.nextEntry;
        }
        return null;
    }

    public Name resolve(String uri, String raw, String prefix, String local) throws SAXException {
        String temp;
        if (uri == null) {
            uri = "";
        }
        if (raw == null) {
            raw = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (local == null) {
            local = "";
        }
        if (raw.length() > 0) {
            int pos = raw.indexOf(58);
            if (pos > 0) {
                String pre = raw.substring(0, pos);
                String loc = raw.substring(pos + 1);
                if (prefix.length() == 0) {
                    prefix = pre;
                } else if (!prefix.equals(pre)) {
                    throw new SAXException("Raw/Prefix mismatch");
                }
                if (local.length() == 0) {
                    local = loc;
                } else if (!local.equals(loc)) {
                    throw new SAXException("Raw/Local Name mismatch");
                }
            } else {
                if (prefix.length() > 0) {
                    throw new SAXException("Raw Name/Prefix mismatch");
                }
                if (local.length() == 0) {
                    local = raw;
                } else if (!local.equals(raw)) {
                    throw new SAXException("Raw Name/Local Name mismatch");
                }
            }
        } else {
            if (local.length() == 0) {
                throw new SAXException("No Raw/Local Name");
            }
            raw = prefix.length() == 0 ? local : prefix + ':' + local;
        }
        if (uri.length() > 0) {
            if (prefix.length() > 0 && !uri.equals(this.getUri(prefix))) {
                throw new SAXException("URI/Prefix mismatch [" + prefix + "," + uri + "]");
            }
            temp = this.getPrefix(uri);
            if (temp == null) {
                throw new SAXException("URI not declared");
            }
            if (temp.length() > 0) {
                prefix = temp;
                raw = prefix + ':' + local;
            }
        } else {
            temp = this.getUri(prefix);
            if (temp == null) {
                throw new SAXException("Prefix not declared");
            }
            uri = temp;
        }
        NameImpl name = new NameImpl();
        if (uri.length() > 0) {
            name.uri = uri;
        } else {
            name.uri = null;
        }
        name.raw = raw;
        name.prefix = prefix;
        name.local = local;
        return name;
    }

    public static interface Declaration {
        public String getUri();

        public String getPrefix();
    }

    public static interface Name {
        public String getUri();

        public String getPrefix();

        public String getLocalName();

        public String getQName();
    }

    private static class NameImpl
    implements Name {
        private String uri = null;
        private String prefix = null;
        private String local = null;
        private String raw = null;

        private NameImpl() {
        }

        public String getUri() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getLocalName() {
            return this.local;
        }

        public String getQName() {
            return this.raw;
        }
    }

    private static class Entry
    implements Declaration {
        private int uriHash = 0;
        private int prefixHash = 0;
        private String uri = "";
        private String prefix = "";
        private Entry previousDeclaration = null;
        private Entry nextEntry = null;

        private Entry() {
        }

        private static Entry create(String prefix, String uri) {
            Entry e = new Entry();
            if (prefix != null) {
                e.prefix = prefix;
            }
            e.prefixHash = e.prefix.hashCode();
            if (uri != null) {
                e.uri = uri;
            }
            e.uriHash = e.uri.hashCode();
            return e;
        }

        public String getUri() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

