/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.excalibur.instrument.AbstractInstrument;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;
import org.apache.excalibur.instrument.manager.InstrumentDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentManagerConnector;
import org.apache.excalibur.instrument.manager.InstrumentProxy;
import org.apache.excalibur.instrument.manager.InstrumentSample;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentableProxy;
import org.apache.excalibur.instrument.manager.interfaces.NoSuchInstrumentException;
import org.apache.excalibur.instrument.manager.interfaces.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.interfaces.NoSuchInstrumentableException;

public class DefaultInstrumentManager
extends AbstractLogEnabled
implements Configurable,
Initializable,
Disposable,
InstrumentManager,
Instrumentable,
Runnable {
    public static final String INSTRUMENT_TOTAL_MEMORY = "total-memory";
    public static final String INSTRUMENT_FREE_MEMORY = "free-memory";
    public static final String INSTRUMENT_MEMORY = "memory";
    public static final String INSTRUMENT_ACTIVE_THREAD_COUNT = "active-thread-count";
    private String m_name;
    private String m_description;
    private Configuration m_configuration;
    private ArrayList m_connectors = new ArrayList();
    private File m_stateFile;
    private long m_stateInterval;
    private long m_lastStateSave;
    private Object m_semaphore = new Object();
    private HashMap m_instrumentableProxies = new HashMap();
    private InstrumentableProxy[] m_instrumentableProxyArray;
    private InstrumentableDescriptorLocal[] m_instrumentableDescriptorArray;
    private ArrayList m_leasedInstrumentSamples = new ArrayList();
    private InstrumentSample[] m_leasedInstrumentSampleArray;
    private Thread m_runner;
    private String m_instrumentableName = "instrument-manager";
    private ValueInstrument m_totalMemoryInstrument = new ValueInstrument("total-memory");
    private ValueInstrument m_freeMemoryInstrument = new ValueInstrument("free-memory");
    private ValueInstrument m_memoryInstrument = new ValueInstrument("memory");
    private ValueInstrument m_activeThreadCountInstrument = new ValueInstrument("active-thread-count");
    private int m_stateVersion;

    public DefaultInstrumentManager(String name) {
        this();
    }

    public DefaultInstrumentManager() {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Object object = this.m_semaphore;
        synchronized (object) {
            this.m_configuration = configuration;
            this.m_name = configuration.getChild("name").getValue("instrument-manager");
            this.m_description = configuration.getChild("description").getValue(this.m_name);
            Logger connLogger = this.getLogger().getChildLogger("connector");
            Configuration connectorsConf = configuration.getChild("connectors");
            Configuration[] connectorConfs = connectorsConf.getChildren("connector");
            int i = 0;
            while (i < connectorConfs.length) {
                Configuration connectorConf = connectorConfs[i];
                String className = connectorConf.getAttribute("class");
                if (className.equals("altrmi")) {
                    className = "org.apache.excalibur.instrument.manager.altrmi.InstrumentManagerAltrmiConnector";
                }
                try {
                    Class<?> clazz = Class.forName(className);
                    InstrumentManagerConnector connector = (InstrumentManagerConnector)clazz.newInstance();
                    connector.setInstrumentManager(this);
                    ContainerUtil.enableLogging((Object)connector, (Logger)connLogger);
                    ContainerUtil.configure((Object)connector, (Configuration)connectorConf);
                    ContainerUtil.start((Object)connector);
                    this.m_connectors.add(connector);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to create connector because: " + e);
                }
                ++i;
            }
            Configuration instrumentablesConf = configuration.getChild("instrumentables");
            Configuration[] instrumentableConfs = instrumentablesConf.getChildren("instrumentable");
            int i2 = 0;
            while (i2 < instrumentableConfs.length) {
                Configuration instrumentableConf = instrumentableConfs[i2];
                String instrumentableName = instrumentableConf.getAttribute("name");
                InstrumentableProxy instrumentableProxy = new InstrumentableProxy(this, null, instrumentableName, instrumentableName);
                instrumentableProxy.enableLogging(this.getLogger());
                instrumentableProxy.configure(instrumentableConf);
                this.m_instrumentableProxies.put(instrumentableName, instrumentableProxy);
                this.m_instrumentableProxyArray = null;
                this.m_instrumentableDescriptorArray = null;
                ++i2;
            }
            Configuration stateFileConf = configuration.getChild("state-file");
            this.m_stateInterval = stateFileConf.getAttributeAsLong("interval", 60000L);
            String stateFile = stateFileConf.getValue(null);
            if (stateFile != null) {
                this.m_stateFile = new File(stateFile);
                if (this.m_stateFile.exists()) {
                    try {
                        this.loadStateFromFile(this.m_stateFile);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Unable to load the instrument manager state.  The configuration may have been corruptped.  A backup may have been made in the same directory when it was saved.", (Throwable)e);
                    }
                }
            }
        }
    }

    public void initialize() throws Exception {
        this.registerInstrumentable(this, this.getInstrumentableName());
        if (this.m_runner == null) {
            this.m_runner = new Thread((Runnable)this, "InstrumentManagerRunner");
            this.m_runner.start();
        }
    }

    public void dispose() {
        if (this.m_runner != null) {
            this.m_runner = null;
        }
        Iterator iter = this.m_connectors.iterator();
        while (iter.hasNext()) {
            InstrumentManagerConnector connector = (InstrumentManagerConnector)iter.next();
            try {
                ContainerUtil.stop((Object)connector);
                ContainerUtil.dispose((Object)connector);
            }
            catch (Exception e) {
                this.getLogger().error("Encountered an unexpected error shutting down a connector", (Throwable)e);
            }
        }
        this.saveState();
    }

    public void registerInstrumentable(Instrumentable instrumentable, String instrumentableName) throws Exception {
        this.getLogger().debug("Registering Instrumentable: " + instrumentableName);
        Object object = this.m_semaphore;
        synchronized (object) {
            int pos = instrumentableName.indexOf(46);
            if (pos >= 0) {
                String parentName = instrumentableName.substring(0, pos);
                String childName = instrumentableName.substring(pos + 1);
                InstrumentableProxy instrumentableProxy = (InstrumentableProxy)((Object)this.m_instrumentableProxies.get(parentName));
                if (instrumentableProxy == null) {
                    instrumentableProxy = new InstrumentableProxy(this, null, parentName, parentName);
                    instrumentableProxy.enableLogging(this.getLogger());
                    this.m_instrumentableProxies.put(parentName, instrumentableProxy);
                    this.m_instrumentableProxyArray = null;
                    this.m_instrumentableDescriptorArray = null;
                    this.registerDummyInstrumentableInner(instrumentable, instrumentableProxy, parentName, childName);
                } else {
                    this.registerDummyInstrumentableInner(instrumentable, instrumentableProxy, parentName, childName);
                }
            } else {
                InstrumentableProxy instrumentableProxy = (InstrumentableProxy)((Object)this.m_instrumentableProxies.get(instrumentableName));
                if (instrumentableProxy == null) {
                    instrumentableProxy = new InstrumentableProxy(this, null, instrumentableName, instrumentableName);
                    instrumentableProxy.enableLogging(this.getLogger());
                    this.m_instrumentableProxies.put(instrumentableName, instrumentableProxy);
                    this.m_instrumentableProxyArray = null;
                    this.m_instrumentableDescriptorArray = null;
                    this.registerInstrumentableInner(instrumentable, instrumentableProxy, instrumentableName);
                } else {
                    this.registerInstrumentableInner(instrumentable, instrumentableProxy, instrumentableName);
                }
            }
        }
        this.stateChanged();
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public InstrumentableDescriptorLocal getInstrumentableDescriptor(String instrumentableName) throws NoSuchInstrumentableException {
        InstrumentableProxy proxy = this.getInstrumentableProxy(instrumentableName);
        if (proxy == null) {
            throw new NoSuchInstrumentableException("No instrumentable can be found using name: " + instrumentableName);
        }
        return proxy.getDescriptor();
    }

    public InstrumentableDescriptorLocal[] getInstrumentableDescriptors() {
        InstrumentableDescriptorLocal[] descriptors = this.m_instrumentableDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateInstrumentableDescriptorArray();
        }
        return descriptors;
    }

    public InstrumentableDescriptorLocal locateInstrumentableDescriptor(String instrumentableName) throws NoSuchInstrumentableException {
        InstrumentableProxy instrumentableProxy = this.locateDeepestInstrumentableProxy(instrumentableName);
        if (instrumentableProxy != null && instrumentableProxy.getName().equals(instrumentableName)) {
            return instrumentableProxy.getDescriptor();
        }
        throw new NoSuchInstrumentableException("No instrumentable can be found with the name: " + instrumentableName);
    }

    public InstrumentDescriptorLocal locateInstrumentDescriptor(String instrumentName) throws NoSuchInstrumentException {
        InstrumentProxy instrumentProxy;
        InstrumentableProxy instrumentableProxy = this.locateDeepestInstrumentableProxy(instrumentName);
        if (instrumentableProxy != null && (instrumentProxy = instrumentableProxy.getInstrumentProxy(instrumentName)) != null && instrumentProxy.getName().equals(instrumentName)) {
            return instrumentProxy.getDescriptor();
        }
        throw new NoSuchInstrumentException("No instrument can be found with the name: " + instrumentName);
    }

    public InstrumentSampleDescriptorLocal locateInstrumentSampleDescriptor(String sampleName) throws NoSuchInstrumentSampleException {
        InstrumentSample sample;
        InstrumentProxy instrumentProxy;
        InstrumentableProxy instrumentableProxy = this.locateDeepestInstrumentableProxy(sampleName);
        if (instrumentableProxy != null && (instrumentProxy = instrumentableProxy.getInstrumentProxy(sampleName)) != null && (sample = instrumentProxy.getInstrumentSample(sampleName)) != null && sample.getName().equals(sampleName)) {
            return sample.getDescriptor();
        }
        throw new NoSuchInstrumentException("No instrument sample can be found with the name: " + sampleName);
    }

    int getStateVersion() {
        return this.m_stateVersion;
    }

    public void invokeGarbageCollection() {
        System.gc();
    }

    public void loadStateFromFile(File stateFile) throws Exception {
        long now = System.currentTimeMillis();
        this.getLogger().debug("Loading Instrument Manager state from: " + stateFile.getAbsolutePath());
        FileInputStream is = new FileInputStream(stateFile);
        try {
            this.loadStateFromStream(is);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
        this.getLogger().debug("Loading Instrument Manager state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    public void loadStateFromStream(InputStream is) throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration stateConfig = builder.build(is);
        this.loadStateFromConfiguration(stateConfig);
    }

    public void loadStateFromConfiguration(Configuration state) throws ConfigurationException {
        Configuration[] instrumentableConfs = state.getChildren("instrumentable");
        int i = 0;
        while (i < instrumentableConfs.length) {
            Configuration instrumentableConf = instrumentableConfs[i];
            String instrumentableName = instrumentableConf.getAttribute("name");
            InstrumentableProxy instrumentableProxy = this.getInstrumentableProxy(instrumentableName);
            if (instrumentableProxy == null) {
                instrumentableProxy = new InstrumentableProxy(this, null, instrumentableName, instrumentableName);
                instrumentableProxy.enableLogging(this.getLogger());
                this.m_instrumentableProxies.put(instrumentableName, instrumentableProxy);
                this.m_instrumentableProxyArray = null;
                this.m_instrumentableDescriptorArray = null;
            }
            instrumentableProxy.loadState(instrumentableConf);
            ++i;
        }
        this.stateChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveStateToFile(File stateFile) throws Exception {
        byte[] data;
        long now = System.currentTimeMillis();
        this.getLogger().debug("Saving Instrument Manager state to: " + stateFile.getAbsolutePath());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.saveStateToStream(os);
            data = os.toByteArray();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            os.close();
            throw throwable;
        }
        os.close();
        File renameFile = null;
        boolean success = false;
        if (stateFile.exists()) {
            renameFile = new File(stateFile.getAbsolutePath() + "." + now + ".backup");
            stateFile.renameTo(renameFile);
        }
        FileOutputStream fos = new FileOutputStream(stateFile);
        try {
            fos.write(data);
            success = true;
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            fos.close();
            if (!success) {
                stateFile.delete();
            }
            if (renameFile == null) throw throwable;
            if (success) {
                renameFile.delete();
                throw throwable;
            }
            renameFile.renameTo(stateFile);
            throw throwable;
        }
        fos.close();
        if (!success) {
            stateFile.delete();
        }
        if (renameFile != null) {
            if (success) {
                renameFile.delete();
            } else {
                renameFile.renameTo(stateFile);
            }
        }
        this.getLogger().debug("Saving Instrument Manager state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    public void saveStateToStream(OutputStream os) throws Exception {
        Configuration stateConfig = this.saveStateToConfiguration();
        DefaultConfigurationSerializer serializer = new DefaultConfigurationSerializer();
        serializer.setIndent(true);
        serializer.serialize(os, stateConfig);
    }

    public Configuration saveStateToConfiguration() {
        DefaultConfiguration state = new DefaultConfiguration("instrument-manager-state", "-");
        InstrumentableProxy[] instrumentableProxies = this.m_instrumentableProxyArray;
        if (instrumentableProxies == null) {
            instrumentableProxies = this.updateInstrumentableProxyArray();
        }
        int i = 0;
        while (i < instrumentableProxies.length) {
            Configuration childState = instrumentableProxies[i].saveState();
            if (childState != null) {
                state.addChild(childState);
            }
            ++i;
        }
        return state;
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.m_totalMemoryInstrument, this.m_freeMemoryInstrument, this.m_memoryInstrument, this.m_activeThreadCountInstrument};
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }

    public void run() {
        while (this.m_runner != null) {
            try {
                Thread.sleep(1000L);
                this.memoryInstruments();
                this.threadInstruments();
                this.testInstrumentSampleLeases();
                long now = System.currentTimeMillis();
                if (now - this.m_lastStateSave < this.m_stateInterval) continue;
                this.saveState();
            }
            catch (Throwable t) {
                this.getLogger().error("Encountered an unexpected error.", t);
            }
        }
    }

    private void saveState() {
        long now;
        this.m_lastStateSave = now = System.currentTimeMillis();
        if (this.m_stateFile == null) {
            return;
        }
        try {
            this.saveStateToFile(this.m_stateFile);
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to save the Instrument Manager state", (Throwable)e);
        }
    }

    private InstrumentableProxy getInstrumentableProxy(String instrumentableName) {
        String name = instrumentableName;
        while (true) {
            InstrumentableProxy proxy;
            if ((proxy = (InstrumentableProxy)((Object)this.m_instrumentableProxies.get(name))) != null) {
                return proxy;
            }
            int pos = name.lastIndexOf(46);
            if (pos <= 0) break;
            name = name.substring(0, pos);
        }
        return null;
    }

    private InstrumentableProxy locateDeepestInstrumentableProxy(String instrumentableName) {
        InstrumentableProxy deepestProxy = null;
        InstrumentableProxy proxy = this.getInstrumentableProxy(instrumentableName);
        while (proxy != null) {
            deepestProxy = proxy;
            proxy = deepestProxy.getChildInstrumentableProxy(instrumentableName);
        }
        return deepestProxy;
    }

    private void memoryInstruments() {
        Runtime runtime = null;
        long totalMemory = -1L;
        long freeMemory = -1L;
        if (this.m_totalMemoryInstrument.isActive()) {
            runtime = Runtime.getRuntime();
            totalMemory = runtime.totalMemory();
            this.m_totalMemoryInstrument.setValue((int)totalMemory);
        }
        if (this.m_freeMemoryInstrument.isActive()) {
            if (runtime == null) {
                runtime = Runtime.getRuntime();
            }
            freeMemory = runtime.freeMemory();
            this.m_freeMemoryInstrument.setValue((int)freeMemory);
        }
        if (this.m_memoryInstrument.isActive()) {
            if (runtime == null) {
                runtime = Runtime.getRuntime();
            }
            if (totalMemory < 0L) {
                totalMemory = runtime.totalMemory();
            }
            if (freeMemory < 0L) {
                freeMemory = runtime.freeMemory();
            }
            this.m_memoryInstrument.setValue((int)(totalMemory - freeMemory));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void threadInstruments() {
        if (this.m_activeThreadCountInstrument.isActive()) {
            ThreadGroup parent;
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while ((parent = threadGroup.getParent()) != null) {
                void var2_2;
                threadGroup = var2_2;
            }
            this.m_activeThreadCountInstrument.setValue(threadGroup.activeCount());
        }
    }

    private void testInstrumentSampleLeases() {
        InstrumentSample[] samples;
        long now = System.currentTimeMillis();
        ArrayList arrayList = this.m_leasedInstrumentSamples;
        synchronized (arrayList) {
            samples = this.m_leasedInstrumentSampleArray;
            if (samples == null) {
                this.m_leasedInstrumentSampleArray = new InstrumentSample[this.m_leasedInstrumentSamples.size()];
                this.m_leasedInstrumentSamples.toArray(this.m_leasedInstrumentSampleArray);
                samples = this.m_leasedInstrumentSampleArray;
            }
        }
        int i = 0;
        while (i < samples.length) {
            InstrumentSample sample = samples[i];
            long expire = sample.getLeaseExpirationTime();
            if (now >= expire) {
                InstrumentProxy instrument = sample.getInstrumentProxy();
                instrument.removeInstrumentSample(sample);
                sample.expire();
                this.m_leasedInstrumentSamples.remove(sample);
                this.m_leasedInstrumentSampleArray = null;
            }
            ++i;
        }
    }

    void registerLeasedInstrumentSample(InstrumentSample instrumentSample) {
        ArrayList arrayList = this.m_leasedInstrumentSamples;
        synchronized (arrayList) {
            if (instrumentSample.getLeaseExpirationTime() <= 0L) {
                throw new IllegalStateException("Got an InstrumentSample that was not leased.");
            }
            if (this.m_leasedInstrumentSamples.indexOf(instrumentSample) < 0) {
                this.m_leasedInstrumentSamples.add(instrumentSample);
                this.m_leasedInstrumentSampleArray = null;
            }
        }
    }

    private InstrumentableProxy[] updateInstrumentableProxyArray() {
        Object object = this.m_semaphore;
        synchronized (object) {
            this.m_instrumentableProxyArray = new InstrumentableProxy[this.m_instrumentableProxies.size()];
            this.m_instrumentableProxies.values().toArray(this.m_instrumentableProxyArray);
            Arrays.sort(this.m_instrumentableProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentableProxy)((Object)o1)).getDescription().compareTo(((InstrumentableProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            InstrumentableProxy[] instrumentableProxyArray = this.m_instrumentableProxyArray;
            return instrumentableProxyArray;
        }
    }

    private InstrumentableDescriptorLocal[] updateInstrumentableDescriptorArray() {
        Object object = this.m_semaphore;
        synchronized (object) {
            if (this.m_instrumentableProxyArray == null) {
                this.updateInstrumentableProxyArray();
            }
            this.m_instrumentableDescriptorArray = new InstrumentableDescriptorLocal[this.m_instrumentableProxyArray.length];
            int i = 0;
            while (i < this.m_instrumentableProxyArray.length) {
                this.m_instrumentableDescriptorArray[i] = this.m_instrumentableProxyArray[i].getDescriptor();
                ++i;
            }
            InstrumentableDescriptorLocal[] instrumentableDescriptorLocalArray = this.m_instrumentableDescriptorArray;
            return instrumentableDescriptorLocalArray;
        }
    }

    private void registerDummyInstrumentableInner(Instrumentable instrumentable, InstrumentableProxy instrumentableProxy, String instrumentableName, String childName) throws Exception {
        int pos = childName.indexOf(46);
        if (pos >= 0) {
            String newParentName = childName.substring(0, pos);
            String newChildName = childName.substring(pos + 1);
            String fullChildName = instrumentableName + "." + newParentName;
            this.getLogger().debug("Registering Child Instrumentable: " + fullChildName);
            InstrumentableProxy proxy = instrumentableProxy.getChildInstrumentableProxy(fullChildName);
            if (proxy == null) {
                proxy = new InstrumentableProxy(this, instrumentableProxy, fullChildName, newParentName);
                proxy.enableLogging(this.getLogger());
                instrumentableProxy.addChildInstrumentableProxy(proxy);
            }
            this.registerDummyInstrumentableInner(instrumentable, proxy, fullChildName, newChildName);
        } else {
            String fullChildName = instrumentableName + "." + childName;
            this.getLogger().debug("Registering Child Instrumentable: " + fullChildName);
            InstrumentableProxy proxy = instrumentableProxy.getChildInstrumentableProxy(fullChildName);
            if (proxy == null) {
                proxy = new InstrumentableProxy(this, instrumentableProxy, fullChildName, childName);
                proxy.enableLogging(this.getLogger());
                instrumentableProxy.addChildInstrumentableProxy(proxy);
            }
            this.registerInstrumentableInner(instrumentable, proxy, fullChildName);
        }
    }

    private void registerInstrumentableInner(Instrumentable instrumentable, InstrumentableProxy instrumentableProxy, String instrumentableName) throws Exception {
        instrumentableProxy.setRegistered();
        Instrument[] instruments = instrumentable.getInstruments();
        int i = 0;
        while (i < instruments.length) {
            block17: {
                InstrumentProxy proxy;
                block19: {
                    String instrumentName;
                    Instrument instrument;
                    block20: {
                        block18: {
                            block16: {
                                instrument = instruments[i];
                                instrumentName = instrument.getInstrumentName();
                                String fullInstrumentName = instrumentableName + "." + instrumentName;
                                this.getLogger().debug("Registering Instrument: " + fullInstrumentName);
                                proxy = instrumentableProxy.getInstrumentProxy(fullInstrumentName);
                                if (proxy != null) break block16;
                                proxy = new InstrumentProxy(instrumentableProxy, fullInstrumentName, instrumentName);
                                proxy.enableLogging(this.getLogger());
                                if (instrument instanceof CounterInstrument) {
                                    proxy.setType(1);
                                } else if (instrument instanceof ValueInstrument) {
                                    proxy.setType(2);
                                } else {
                                    throw new ServiceException(fullInstrumentName, "Encountered an unknown Instrument type for the Instrument with key, " + fullInstrumentName + ": " + instrument.getClass().getName());
                                }
                                proxy.setRegistered();
                                ((AbstractInstrument)instrument).setInstrumentProxy((org.apache.excalibur.instrument.InstrumentProxy)proxy);
                                instrumentableProxy.addInstrumentProxy(proxy);
                                break block17;
                            }
                            if (!(instrument instanceof CounterInstrument)) break block18;
                            switch (proxy.getType()) {
                                case 1: {
                                    ((AbstractInstrument)instrument).setInstrumentProxy((org.apache.excalibur.instrument.InstrumentProxy)proxy);
                                    break block19;
                                }
                                case 0: {
                                    proxy.setType(1);
                                    ((AbstractInstrument)instrument).setInstrumentProxy((org.apache.excalibur.instrument.InstrumentProxy)proxy);
                                    break block19;
                                }
                                default: {
                                    throw new ServiceException(instrumentName, "Instruments of more than one type are assigned to name: " + instrumentName);
                                }
                            }
                        }
                        if (!(instrument instanceof ValueInstrument)) break block20;
                        switch (proxy.getType()) {
                            case 2: {
                                ((AbstractInstrument)instrument).setInstrumentProxy((org.apache.excalibur.instrument.InstrumentProxy)proxy);
                                break block19;
                            }
                            case 0: {
                                proxy.setType(2);
                                ((AbstractInstrument)instrument).setInstrumentProxy((org.apache.excalibur.instrument.InstrumentProxy)proxy);
                                break block19;
                            }
                            default: {
                                throw new ServiceException(instrumentName, "Instruments of more than one type are assigned to name: " + instrumentName);
                            }
                        }
                    }
                    throw new ServiceException(instrumentName, "Encountered an unknown Instrument type for the Instrument with name, " + instrumentName + ": " + instrument.getClass().getName());
                }
                proxy.setRegistered();
            }
            ++i;
        }
        Instrumentable[] children = instrumentable.getChildInstrumentables();
        int i2 = 0;
        while (i2 < children.length) {
            Instrumentable child = children[i2];
            String childName = child.getInstrumentableName();
            if (childName == null) {
                String msg = "The getInstrumentableName() method of a child Instrumentable of " + instrumentableName + " returned null.  Child class: " + child.getClass().getName();
                this.getLogger().debug(msg);
                throw new ServiceException(instrumentable.getClass().getName(), msg);
            }
            String fullChildName = instrumentableName + "." + childName;
            this.getLogger().debug("Registering Child Instrumentable: " + fullChildName);
            InstrumentableProxy proxy = instrumentableProxy.getChildInstrumentableProxy(fullChildName);
            if (proxy == null) {
                proxy = new InstrumentableProxy(this, instrumentableProxy, fullChildName, childName);
                proxy.enableLogging(this.getLogger());
                instrumentableProxy.addChildInstrumentableProxy(proxy);
            }
            this.registerInstrumentableInner(child, proxy, fullChildName);
            ++i2;
        }
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
    }
}

