/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentProxy;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptorLocalImpl;

class InstrumentableProxy
extends AbstractLogEnabled
implements Configurable {
    private DefaultInstrumentManager m_instrumentManager;
    private InstrumentableProxy m_parentInstrumentableProxy;
    private boolean m_configured;
    private boolean m_registered;
    private String m_name;
    private String m_description;
    private InstrumentableDescriptorLocalImpl m_descriptor;
    private HashMap m_childInstrumentableProxies = new HashMap();
    private InstrumentableProxy[] m_childInstrumentableProxyArray;
    private InstrumentableDescriptorLocal[] m_childInstrumentableDescriptorArray;
    private HashMap m_instrumentProxies = new HashMap();
    private InstrumentProxy[] m_instrumentProxyArray;
    private InstrumentDescriptorLocal[] m_instrumentDescriptorArray;
    private int m_stateVersion;

    InstrumentableProxy(DefaultInstrumentManager instrumentManager, InstrumentableProxy parentInstrumentableProxy, String name, String description) {
        this.m_instrumentManager = instrumentManager;
        this.m_parentInstrumentableProxy = parentInstrumentableProxy;
        this.m_name = name;
        this.m_description = description;
        this.m_descriptor = new InstrumentableDescriptorLocalImpl(this);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_description = configuration.getAttribute("description", this.m_description);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Configuring Instrumentable: " + this.m_name + " as \"" + this.m_description + "\"");
            }
            this.m_configured = true;
            Configuration[] childConfs = configuration.getChildren("instrumentable");
            int i = 0;
            while (i < childConfs.length) {
                Configuration childConf = childConfs[i];
                String childName = childConf.getAttribute("name");
                String fullChildName = this.m_name + "." + childName;
                InstrumentableProxy childProxy = new InstrumentableProxy(this.m_instrumentManager, this, fullChildName, childName);
                childProxy.enableLogging(this.getLogger());
                childProxy.configure(childConf);
                this.m_childInstrumentableProxies.put(fullChildName, childProxy);
                this.m_childInstrumentableProxyArray = null;
                this.m_childInstrumentableDescriptorArray = null;
                ++i;
            }
            Configuration[] instrumentConfs = configuration.getChildren("instrument");
            int i2 = 0;
            while (i2 < instrumentConfs.length) {
                Configuration instrumentConf = instrumentConfs[i2];
                String instrumentName = instrumentConf.getAttribute("name");
                String fullInstrumentName = this.m_name + "." + instrumentName;
                InstrumentProxy instrumentProxy = new InstrumentProxy(this, fullInstrumentName, instrumentName);
                instrumentProxy.enableLogging(this.getLogger());
                instrumentProxy.configure(instrumentConf);
                this.m_instrumentProxies.put(fullInstrumentName, instrumentProxy);
                this.m_instrumentProxyArray = null;
                this.m_instrumentDescriptorArray = null;
                ++i2;
            }
        }
    }

    DefaultInstrumentManager getInstrumentManager() {
        return this.m_instrumentManager;
    }

    InstrumentableProxy getParentInstrumentableProxy() {
        return this.m_parentInstrumentableProxy;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isRegistered() {
        return this.m_registered;
    }

    void setRegistered() {
        this.m_registered = true;
    }

    String getName() {
        return this.m_name;
    }

    void setDescription(String description) {
        this.m_description = description;
    }

    String getDescription() {
        return this.m_description;
    }

    InstrumentableDescriptorLocal getDescriptor() {
        return this.m_descriptor;
    }

    void addChildInstrumentableProxy(InstrumentableProxy childInstrumentableProxy) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_childInstrumentableProxies.put(childInstrumentableProxy.getName(), childInstrumentableProxy);
            this.m_childInstrumentableProxyArray = null;
            this.m_childInstrumentableDescriptorArray = null;
        }
        this.stateChanged();
    }

    InstrumentableProxy getChildInstrumentableProxy(String childInstrumentableName) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            String name = childInstrumentableName;
            while (true) {
                InstrumentableProxy proxy;
                if ((proxy = (InstrumentableProxy)((Object)this.m_childInstrumentableProxies.get(name))) != null) {
                    InstrumentableProxy instrumentableProxy2 = proxy;
                    return instrumentableProxy2;
                }
                int pos = name.lastIndexOf(46);
                if (pos <= 0) break;
                name = name.substring(0, pos);
            }
            InstrumentableProxy instrumentableProxy3 = null;
            return instrumentableProxy3;
        }
    }

    InstrumentableProxy[] getChildInstrumentableProxies() {
        InstrumentableProxy[] proxies = this.m_childInstrumentableProxyArray;
        if (proxies == null) {
            proxies = this.updateChildInstrumentableProxyArray();
        }
        return proxies;
    }

    InstrumentableDescriptorLocal[] getChildInstrumentableDescriptors() {
        InstrumentableDescriptorLocal[] descriptors = this.m_childInstrumentableDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateChildInstrumentableDescriptorArray();
        }
        return descriptors;
    }

    private InstrumentableProxy[] updateChildInstrumentableProxyArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_childInstrumentableProxyArray = new InstrumentableProxy[this.m_childInstrumentableProxies.size()];
            this.m_childInstrumentableProxies.values().toArray(this.m_childInstrumentableProxyArray);
            Arrays.sort(this.m_childInstrumentableProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentableProxy)((Object)o1)).getDescription().compareTo(((InstrumentableProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            InstrumentableProxy[] instrumentableProxyArray = this.m_childInstrumentableProxyArray;
            return instrumentableProxyArray;
        }
    }

    private InstrumentableDescriptorLocal[] updateChildInstrumentableDescriptorArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            if (this.m_childInstrumentableProxyArray == null) {
                this.updateChildInstrumentableProxyArray();
            }
            this.m_childInstrumentableDescriptorArray = new InstrumentableDescriptorLocal[this.m_childInstrumentableProxyArray.length];
            int i = 0;
            while (i < this.m_childInstrumentableProxyArray.length) {
                this.m_childInstrumentableDescriptorArray[i] = this.m_childInstrumentableProxyArray[i].getDescriptor();
                ++i;
            }
            InstrumentableDescriptorLocal[] instrumentableDescriptorLocalArray = this.m_childInstrumentableDescriptorArray;
            return instrumentableDescriptorLocalArray;
        }
    }

    void addInstrumentProxy(InstrumentProxy instrumentProxy) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_instrumentProxies.put(instrumentProxy.getName(), instrumentProxy);
            this.m_instrumentProxyArray = null;
            this.m_instrumentDescriptorArray = null;
        }
        this.stateChanged();
    }

    InstrumentProxy getInstrumentProxy(String instrumentName) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            String name = instrumentName;
            while (true) {
                InstrumentProxy proxy;
                if ((proxy = (InstrumentProxy)((Object)this.m_instrumentProxies.get(name))) != null) {
                    InstrumentProxy instrumentProxy = proxy;
                    return instrumentProxy;
                }
                int pos = name.lastIndexOf(46);
                if (pos <= 0) break;
                name = name.substring(0, pos);
            }
            InstrumentProxy instrumentProxy = null;
            return instrumentProxy;
        }
    }

    InstrumentProxy[] getInstrumentProxies() {
        InstrumentProxy[] proxies = this.m_instrumentProxyArray;
        if (proxies == null) {
            proxies = this.updateInstrumentProxyArray();
        }
        return proxies;
    }

    InstrumentDescriptorLocal[] getInstrumentDescriptors() {
        InstrumentDescriptorLocal[] descriptors = this.m_instrumentDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateInstrumentDescriptorArray();
        }
        return descriptors;
    }

    int getStateVersion() {
        return this.m_stateVersion;
    }

    private InstrumentProxy[] updateInstrumentProxyArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_instrumentProxyArray = new InstrumentProxy[this.m_instrumentProxies.size()];
            this.m_instrumentProxies.values().toArray(this.m_instrumentProxyArray);
            Arrays.sort(this.m_instrumentProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentProxy)((Object)o1)).getDescription().compareTo(((InstrumentProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            InstrumentProxy[] instrumentProxyArray = this.m_instrumentProxyArray;
            return instrumentProxyArray;
        }
    }

    private InstrumentDescriptorLocal[] updateInstrumentDescriptorArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            if (this.m_instrumentProxyArray == null) {
                this.updateInstrumentProxyArray();
            }
            this.m_instrumentDescriptorArray = new InstrumentDescriptorLocal[this.m_instrumentProxyArray.length];
            int i = 0;
            while (i < this.m_instrumentProxyArray.length) {
                this.m_instrumentDescriptorArray[i] = this.m_instrumentProxyArray[i].getDescriptor();
                ++i;
            }
            InstrumentDescriptorLocal[] instrumentDescriptorLocalArray = this.m_instrumentDescriptorArray;
            return instrumentDescriptorLocalArray;
        }
    }

    Configuration saveState() {
        boolean empty = true;
        DefaultConfiguration state = new DefaultConfiguration("instrumentable", "-");
        state.setAttribute("name", this.m_name);
        InstrumentableProxy[] childProxies = this.getChildInstrumentableProxies();
        int i = 0;
        while (i < childProxies.length) {
            Configuration childState = childProxies[i].saveState();
            if (childState != null) {
                empty = false;
                state.addChild(childState);
            }
            ++i;
        }
        InstrumentProxy[] proxies = this.getInstrumentProxies();
        int i2 = 0;
        while (i2 < proxies.length) {
            Configuration childState = proxies[i2].saveState();
            if (childState != null) {
                empty = false;
                state.addChild(childState);
            }
            ++i2;
        }
        if (empty) {
            state = null;
        }
        return state;
    }

    void loadState(Configuration state) throws ConfigurationException {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            Configuration[] childConfs = state.getChildren("instrumentable");
            int i = 0;
            while (i < childConfs.length) {
                Configuration childConf = childConfs[i];
                String fullChildName = childConf.getAttribute("name");
                InstrumentableProxy childProxy = this.getChildInstrumentableProxy(fullChildName);
                if (childProxy == null) {
                    String childName = fullChildName.startsWith(this.m_name + ".") ? fullChildName.substring(this.m_name.length() + 1) : "BADNAME." + fullChildName;
                    childProxy = new InstrumentableProxy(this.m_instrumentManager, this, fullChildName, childName);
                    childProxy.enableLogging(this.getLogger());
                    this.m_childInstrumentableProxies.put(fullChildName, childProxy);
                    this.m_childInstrumentableProxyArray = null;
                    this.m_childInstrumentableDescriptorArray = null;
                }
                childProxy.loadState(childConf);
                ++i;
            }
            Configuration[] instrumentConfs = state.getChildren("instrument");
            int i2 = 0;
            while (i2 < instrumentConfs.length) {
                Configuration instrumentConf = instrumentConfs[i2];
                String fullInstrumentName = instrumentConf.getAttribute("name");
                InstrumentProxy instrumentProxy = this.getInstrumentProxy(fullInstrumentName);
                if (instrumentProxy == null) {
                    String instrumentName = fullInstrumentName.startsWith(this.m_name + ".") ? fullInstrumentName.substring(this.m_name.length() + 1) : "BADNAME." + fullInstrumentName;
                    instrumentProxy = new InstrumentProxy(this, fullInstrumentName, instrumentName);
                    instrumentProxy.enableLogging(this.getLogger());
                    this.m_instrumentProxies.put(fullInstrumentName, instrumentProxy);
                    this.m_instrumentProxyArray = null;
                    this.m_instrumentDescriptorArray = null;
                }
                instrumentProxy.loadState(instrumentConf);
                ++i2;
            }
        }
        this.stateChanged();
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
        if (this.m_parentInstrumentableProxy == null) {
            this.m_instrumentManager.stateChanged();
        } else {
            this.m_parentInstrumentableProxy.stateChanged();
        }
    }
}

