/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class Expression {
    public static final int OP_SUM = 1;
    public static final int OP_MINUS = 2;
    public static final int OP_MULT = 3;
    public static final int OP_DIV = 4;
    public static final int OP_CONSTANT = 5;
    public static final int OP_STEP = 6;
    public static final int OP_AND = 7;
    public static final int OP_OR = 8;
    public static final int OP_UNARY_MINUS = 9;
    public static final int OP_MOD = 10;
    public static final int OP_LT = 11;
    public static final int OP_GT = 12;
    public static final int OP_LTE = 13;
    public static final int OP_GTE = 14;
    public static final int OP_EQ = 15;
    public static final int OP_NE = 16;
    public static final int OP_VAR = 17;
    public static final int OP_FUNCTION = 18;
    public static final int OP_UNION = 19;
    public static final int OP_LOCATION_PATH = 20;
    public static final int OP_EXPRESSION_PATH = 21;
    public static final int OP_CORE_FUNCTION = 22;
    public static final int OP_KEY_LOOKUP = 23;
    protected static Double ZERO;
    protected static Double ONE;
    protected static Double NaN;
    private int typeCode;
    private boolean contextDependencyKnown = false;
    private boolean contextDependent;

    protected Expression(int typeCode) {
        this.typeCode = typeCode;
    }

    public int getExpressionTypeCode() {
        return this.typeCode;
    }

    protected Expression[] getArguments() {
        return null;
    }

    public boolean isContextDependent() {
        if (!this.contextDependencyKnown) {
            this.contextDependent = this.computeContextDependent();
            this.contextDependencyKnown = true;
        }
        return this.contextDependent;
    }

    public abstract boolean computeContextDependent();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(this.opCodeToString());
        Expression[] args = this.getArguments();
        if (args != null) {
            buffer.append(' ');
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i]);
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected String opCodeToString() {
        switch (this.typeCode) {
            case 5: {
                return "CONST";
            }
            case 6: {
                return "STEP";
            }
            case 1: {
                return "SUM";
            }
            case 19: {
                return "UNION";
            }
            case 2: {
                return "MINUS";
            }
            case 9: {
                return "UNARY_MINUS";
            }
            case 3: {
                return "MULT";
            }
            case 4: {
                return "DIV";
            }
            case 10: {
                return "MOD";
            }
            case 7: {
                return "AND";
            }
            case 8: {
                return "OR";
            }
            case 11: {
                return "LT";
            }
            case 12: {
                return "GT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "GTE";
            }
            case 15: {
                return "EQ";
            }
            case 16: {
                return "NE";
            }
            case 17: {
                return "VAR";
            }
            case 18: {
                return "FUNCTION";
            }
            case 20: {
                return "LOCATION_PATH";
            }
            case 21: {
                return "EXPRESSION_PATH";
            }
            case 22: {
                return "CORE_FUNCTION";
            }
        }
        return "UNKNOWN";
    }

    public abstract Object computeValue(EvalContext var1);

    public abstract Object compute(EvalContext var1);

    public Iterator iterate(EvalContext context) {
        Object result = this.compute(context);
        if (result instanceof EvalContext) {
            return new ValueIterator((EvalContext)result);
        }
        return ValueUtils.iterate(result);
    }

    public Iterator iteratePointers(EvalContext context) {
        Object result = this.compute(context);
        if (result == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (result instanceof EvalContext) {
            return (EvalContext)result;
        }
        return new PointerIterator(ValueUtils.iterate(result), new QName(null, "value"), context.getRootContext().getCurrentNodePointer().getLocale());
    }

    static {
        OP_SUM = 1;
        OP_MINUS = 2;
        OP_MULT = 3;
        OP_DIV = 4;
        OP_CONSTANT = 5;
        OP_STEP = 6;
        OP_AND = 7;
        OP_OR = 8;
        OP_UNARY_MINUS = 9;
        OP_MOD = 10;
        OP_LT = 11;
        OP_GT = 12;
        OP_LTE = 13;
        OP_GTE = 14;
        OP_EQ = 15;
        OP_NE = 16;
        OP_VAR = 17;
        OP_FUNCTION = 18;
        OP_UNION = 19;
        OP_LOCATION_PATH = 20;
        OP_EXPRESSION_PATH = 21;
        OP_CORE_FUNCTION = 22;
        OP_KEY_LOOKUP = 23;
        ZERO = new Double(0.0);
        ONE = new Double(1.0);
        NaN = new Double(Double.NaN);
    }

    public static class ValueIterator
    implements Iterator {
        private Iterator iterator;

        public ValueIterator(Iterator it) {
            this.iterator = it;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object o = this.iterator.next();
            if (o instanceof Pointer) {
                return ((Pointer)o).getValue();
            }
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PointerIterator
    implements Iterator {
        private Iterator iterator;
        private QName qname;
        private Locale locale;

        public PointerIterator(Iterator it, QName qname, Locale locale) {
            this.iterator = it;
            this.qname = qname;
            this.locale = locale;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object o = this.iterator.next();
            return NodePointer.newNodePointer(this.qname, o, this.locale);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

