/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.beans.PropertyDescriptor;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class BeanPropertyPointer
extends PropertyPointer {
    private String propertyName;
    private JXPathBeanInfo beanInfo;
    private PropertyDescriptor[] propertyDescriptors;
    private PropertyDescriptor propertyDescriptor;
    private String[] names;
    private static final Object UNINITIALIZED = new Object();
    private Object baseValue = UNINITIALIZED;
    private Object value = UNINITIALIZED;

    public BeanPropertyPointer(NodePointer parent, JXPathBeanInfo beanInfo) {
        super(parent);
        this.beanInfo = beanInfo;
    }

    public boolean isNode() {
        return false;
    }

    public int getPropertyCount() {
        return this.getPropertyDescriptors().length;
    }

    public String[] getPropertyNames() {
        if (this.names == null) {
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            this.names = new String[pds.length];
            int i = 0;
            while (i < this.names.length) {
                this.names[i] = pds[i].getName();
                ++i;
            }
        }
        return this.names;
    }

    public void setPropertyName(String propertyName) {
        this.setPropertyIndex(PropertyPointer.UNSPECIFIED_PROPERTY);
        this.propertyName = propertyName;
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.propertyName = null;
            this.propertyDescriptor = null;
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
    }

    public int getLength() {
        return ValueUtils.getLength(this.getBaseValue());
    }

    public Object getBaseValue() {
        if (this.baseValue == UNINITIALIZED) {
            PropertyDescriptor pd = this.getPropertyDescriptor();
            if (pd == null) {
                return null;
            }
            this.baseValue = ValueUtils.getValue(this.getBean(), pd);
        }
        return this.baseValue;
    }

    public void setIndex(int index) {
        if (this.index != index) {
            super.setIndex(index);
            this.value = UNINITIALIZED;
        }
    }

    public Object getNodeValue() {
        if (this.value == UNINITIALIZED) {
            PropertyDescriptor pd = this.getPropertyDescriptor();
            this.value = pd == null ? null : (this.index == NodePointer.WHOLE_COLLECTION ? ValueUtils.getValue(this.getBean(), pd) : ValueUtils.getValue(this.getBean(), pd, this.index));
        }
        return this.value;
    }

    protected boolean isActualProperty() {
        return this.getPropertyDescriptor() != null;
    }

    public void setValue(Object value) {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            throw new JXPathException("Cannot set property: " + this.asPath() + " - no such property");
        }
        if (this.index == NodePointer.WHOLE_COLLECTION) {
            ValueUtils.setValue(this.getBean(), pd, value);
        } else {
            ValueUtils.setValue(this.getBean(), pd, this.index, value);
        }
        this.value = value;
    }

    public NodePointer createPath(JXPathContext context) {
        if (this.getNodeValue() == null) {
            int inx;
            AbstractFactory factory = this.getAbstractFactory(context);
            int n = inx = this.index == NodePointer.WHOLE_COLLECTION ? 0 : this.index;
            if (!factory.createObject(context, this, this.getBean(), this.getPropertyName(), inx)) {
                throw new JXPathException("Factory could not create an object for path: " + this.asPath());
            }
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        return this.createPath(context).getValuePointer().createChild(context, name, index);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        return this.createPath(context).getValuePointer().createChild(context, name, index, value);
    }

    private BeanPropertyPointer setIndexExpandingCollection(JXPathContext context, QName name, int index) {
        AbstractFactory factory;
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            throw new JXPathException("Cannot create path: " + this.asPath() + " - property '" + this.getPropertyName() + "' does not exist");
        }
        if (index < 0) {
            throw new JXPathException("Index is less than 1: " + this.asPath());
        }
        if (index >= this.getLength() && !(factory = this.getAbstractFactory(context)).createObject(context, this, this.getBean(), this.getPropertyName(), index)) {
            throw new JXPathException("Factory could not create path " + this.asPath());
        }
        BeanPropertyPointer clone = (BeanPropertyPointer)this.clone();
        clone.baseValue = UNINITIALIZED;
        clone.value = UNINITIALIZED;
        clone.setIndex(index);
        return clone;
    }

    public void remove() {
        if (this.index == NodePointer.WHOLE_COLLECTION) {
            this.setValue(null);
        } else if (this.isCollection()) {
            Object collection = ValueUtils.remove(this.getBaseValue(), this.index);
            ValueUtils.setValue(this.getBean(), this.getPropertyDescriptor(), collection);
        } else if (this.index == 0) {
            this.index = NodePointer.WHOLE_COLLECTION;
            this.setValue(null);
        }
    }

    public String getPropertyName() {
        PropertyDescriptor pd;
        if (this.propertyName == null && (pd = this.getPropertyDescriptor()) != null) {
            this.propertyName = pd.getName();
        }
        return this.propertyName != null ? this.propertyName : "*";
    }

    private PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            int inx = this.getPropertyIndex();
            if (inx == PropertyPointer.UNSPECIFIED_PROPERTY) {
                this.propertyDescriptor = this.beanInfo.getPropertyDescriptor(this.propertyName);
            } else {
                PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
                this.propertyDescriptor = inx >= 0 && inx < propertyDescriptors.length ? propertyDescriptors[inx] : null;
            }
        }
        return this.propertyDescriptor;
    }

    protected PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        }
        return this.propertyDescriptors;
    }

    private AbstractFactory getAbstractFactory(JXPathContext context) {
        AbstractFactory factory = context.getFactory();
        if (factory == null) {
            throw new JXPathException("Factory is not set on the JXPathContext - cannot create path: " + this.asPath());
        }
        return factory;
    }
}

