/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class NullPropertyPointer
extends PropertyPointer {
    private String propertyName = "*";
    private boolean dynamic = false;

    public NullPropertyPointer(NodePointer parent) {
        super(parent);
    }

    public QName getName() {
        return new QName(null, this.propertyName);
    }

    public void setPropertyIndex(int index) {
    }

    public int getLength() {
        return 0;
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getNodeValue() {
        return null;
    }

    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, new QName(null, this.getPropertyName()));
    }

    protected boolean isActualProperty() {
        return false;
    }

    public boolean isActual() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public void setValue(Object value) {
        throw new JXPathException("Cannot set property " + this.asPath() + ", the target object is null");
    }

    public NodePointer createPath(JXPathContext context) {
        return this.parent.createChild(context, this.getName(), this.getIndex());
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        return this.parent.createChild(context, this.getName(), this.getIndex(), value);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        return this.createPath(context).createChild(context, name, index, value);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        return this.createPath(context).createChild(context, name, index);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setDynamic(boolean flag) {
        this.dynamic = flag;
    }

    public boolean isCollection() {
        return this.getIndex() != NodePointer.WHOLE_COLLECTION;
    }

    public int getPropertyCount() {
        return 0;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public String asPath() {
        if (!this.dynamic) {
            return super.asPath();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getParent().asPath());
        buffer.append("[@name='");
        buffer.append(this.escape(this.getPropertyName()));
        buffer.append("']");
        if (this.index != NodePointer.WHOLE_COLLECTION) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    private String escape(String string) {
        int index = string.indexOf(39);
        while (index != -1) {
            string = string.substring(0, index) + "&apos;" + string.substring(index + 1);
            index = string.indexOf(39);
        }
        index = string.indexOf(34);
        while (index != -1) {
            string = string.substring(0, index) + "&quot;" + string.substring(index + 1);
            index = string.indexOf(34);
        }
        return string;
    }
}

