/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PasswordRecord
extends Record {
    public static final short sid = 19;
    private short field_1_password;

    public PasswordRecord() {
    }

    public PasswordRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PasswordRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 19) {
            throw new RecordFormatException("NOT A PASSWORD RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_password = LittleEndian.getShort(data, 0 + offset);
    }

    public void setPassword(short password) {
        this.field_1_password = password;
    }

    public short getPassword() {
        return this.field_1_password;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PASSWORD]\n");
        buffer.append("    .password       = ").append(Integer.toHexString(this.getPassword())).append("\n");
        buffer.append("[/PASSWORD]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)19);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getPassword());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 19;
    }

    static {
        sid = (short)19;
    }
}

