/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PrecisionRecord
extends Record {
    public static final short sid = 14;
    public short field_1_precision;

    public PrecisionRecord() {
    }

    public PrecisionRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PrecisionRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 14) {
            throw new RecordFormatException("NOT A PRECISION RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_precision = LittleEndian.getShort(data, 0 + offset);
    }

    public void setFullPrecision(boolean fullprecision) {
        this.field_1_precision = fullprecision ? (short)1 : 0;
    }

    public boolean getFullPrecision() {
        return this.field_1_precision == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PRECISION]\n");
        buffer.append("    .precision       = ").append(this.getFullPrecision()).append("\n");
        buffer.append("[/PRECISION]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)14);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_precision);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 14;
    }

    static {
        sid = (short)14;
    }
}

