<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xweb="xalan://com.nwalsh.xalan.Website"
		xmlns:sweb="http://nwalsh.com/xslt/ext/com.nwalsh.saxon.Website"
		exclude-result-prefixes="sweb xweb"
>

	<!--

			Driver file for processing an autolayout.xml file and generating XML
			file, using the 'chunk-tabular' display of website.

	-->

	<!-- TODO : adjust path? -->
	<xsl:import href="../website-2.1b1/xsl/chunk-tabular.xsl"/>

	<xsl:param name="xmlDir" select="''"/>

	<xsl:template name="make.tocentry">
		<xsl:variable name="srcFile" select="@page"/>
		<xsl:variable name="completeSrcFile" select="concat($xmlDir, '/', @page)"/>
		<xsl:variable name="filename">
			<xsl:choose>
				<xsl:when test="@filename">
					<xsl:value-of select="@filename"/>
				</xsl:when>
				<xsl:otherwise>index.html</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="dir">
			<xsl:apply-templates select="." mode="calculate-dir"/>
		</xsl:variable>

		<xsl:variable name="targetFile">
			<xsl:value-of select="$dir"/>
			<xsl:value-of select="$filename-prefix"/>
			<xsl:value-of select="$filename"/>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="function-available('sweb:exists')">
				<xsl:if test="not(sweb:exists($completeSrcFile))">
					<xsl:message terminate="yes">
						<xsl:value-of select="$srcFile"/>
						<xsl:text> does not exist.</xsl:text>
					</xsl:message>
				</xsl:if>
			</xsl:when>
			<xsl:when test="function-available('xweb:exists')">
				<xsl:if test="not(xweb:exists($completeSrcFile))">
					<xsl:message terminate="yes">
						<xsl:value-of select="$srcFile"/>
						<xsl:text> does not exist.</xsl:text>
					</xsl:message>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">
					<xsl:text>Fail: this stylesheet relies on the exists() extension function</xsl:text>
				</xsl:message>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:variable name="output-file">
			<xsl:value-of select="$output-root"/>
			<xsl:text>/</xsl:text>
			<xsl:value-of select="$targetFile"/>
		</xsl:variable>

		<xsl:variable name="needsUpdate">
			<xsl:choose>
				<xsl:when test="function-available('sweb:needsUpdate')">
					<xsl:choose>
						<xsl:when test="$rebuild-all != 0
								or sweb:needsUpdate($autolayout-file, $output-file)
								or sweb:needsUpdate($srcFile, $output-file)">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="function-available('xweb:needsUpdate')">
					<xsl:choose>
						<xsl:when test="$rebuild-all != 0
								or xweb:needsUpdate($autolayout-file, $output-file)
								or xweb:needsUpdate($srcFile, $output-file)">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$needsUpdate != 0">
				<xsl:message>
					<xsl:text>Update: </xsl:text>
					<xsl:value-of select="$output-file"/>
					<xsl:text>: </xsl:text>
					<xsl:value-of select="$srcFile"/>
				</xsl:message>

				<xsl:variable name="webpage" select="document($srcFile,.)"/>
				<xsl:variable name="content">
					<xsl:apply-templates select="$webpage/webpage"/>
				</xsl:variable>

				<xsl:if test="$dry-run = 0">
					<xsl:call-template name="write.chunk">
						<xsl:with-param name="filename" select="$output-file"/>
						<xsl:with-param name="content" select="$content"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>
					<xsl:text>Up-to-date: </xsl:text>
					<xsl:value-of select="$output-file"/>
				</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<!-- Properties for the general table that contains all the page -->
	<xsl:attribute-set name="table.properties">
	  <xsl:attribute name="border">0</xsl:attribute>
	  <xsl:attribute name="cellpadding">5</xsl:attribute>
	  <xsl:attribute name="cellspacing">0</xsl:attribute>
	  <xsl:attribute name="width">100%</xsl:attribute>
	</xsl:attribute-set>

	<!-- Page properties -->
	<xsl:attribute-set name="body.attributes">
		<xsl:attribute name="bgcolor">white</xsl:attribute>
		<xsl:attribute name="text">black</xsl:attribute>
		<xsl:attribute name="link">#330033</xsl:attribute>
		<xsl:attribute name="vlink">#990099</xsl:attribute>
		<xsl:attribute name="alink">#330033</xsl:attribute>
	</xsl:attribute-set>

	<!-- Top navigation bar -->
	<!-- TODO : adjust path and URL ? -->
	<xsl:template name="home.navhead">
		<a href="http://www.freesoftware.fsf.org/sdx/docs/">Documentation SDX</a>
	</xsl:template>

	<!-- Suppress the upper right navigation bar -->
	<xsl:template name="home.navhead.upperright"/>

	<!-- Redefinition of the table of contents left sidebar -->
	<xsl:template match="toc">
	  <xsl:param name="pageid" select="@id"/>

	  <xsl:variable name="relpath">
	    <xsl:call-template name="toc-rel-path">
	      <xsl:with-param name="pageid" select="$pageid"/>
	    </xsl:call-template>
	  </xsl:variable>

	  <xsl:variable name="homebanner"
	                select="/autolayout/config[@param='homebanner-tabular'][1]"/>
	  <xsl:variable name="homebannertext"
	                select="/autolayout/config[@param='homebanner-tabular-text'][1]"/>

	  <xsl:variable name="banner"
	                select="/autolayout/config[@param='banner-tabular'][1]"/>
	  <xsl:variable name="bannertext"
	                select="/autolayout/config[@param='banner-tabular-text'][1]"/>

		<xsl:choose>
			<xsl:when test="$pageid = @id">
				<xsl:choose>
					<xsl:when test="$homebanner">
						<img align="left" border="0">
							<xsl:attribute name="src">
								<xsl:value-of select="$relpath"/>
								<xsl:value-of select="$homebanner/@value"/>
							</xsl:attribute>
							<xsl:attribute name="alt">
								<xsl:value-of select="$homebanner/@altval"/>
							</xsl:attribute>
						</img>
					</xsl:when>
					<xsl:otherwise>
						<p class="navHome"><xsl:value-of select="$homebannertext/@value"/></p>
					</xsl:otherwise>
				</xsl:choose>
				<br clear="all"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$homebanner">
						<a href="{$relpath}{@dir}{$filename-prefix}{@filename}">
							<img align="left" border="0">
								<xsl:attribute name="src">
									<xsl:value-of select="$relpath"/>
									<xsl:value-of select="$banner/@value"/>
								</xsl:attribute>
								<xsl:attribute name="alt">
									<xsl:value-of select="$banner/@altval"/>
								</xsl:attribute>
							</img>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<p class="navHome"><a href="{$relpath}{@dir}{$filename-prefix}{@filename}"><xsl:value-of select="$homebannertext/@value"/></a></p>
					</xsl:otherwise>
				</xsl:choose>
				<br clear="all"/>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:apply-templates select="tocentry">
			<xsl:with-param name="pageid" select="$pageid"/>
			<xsl:with-param name="relpath" select="$relpath"/>
		</xsl:apply-templates>
		<br/>
		<br/>
		<p align="center"><a href="http://www.freesoftware.fsf.org/sdx/"><img src="{$relpath}../graphics/sdx/logo-200.png" alt="SDX" border="0" height="60" width="200"/></a></p>

	</xsl:template>

	<!-- Credits in the footer -->
	<!-- TODO : multilingual... -->
	<xsl:template name="webpage.table.footer">
		<tr><td colspan="2"><hr/></td></tr>
		<tr valign="top">
			<td/>
			<td align="right">
				<xsl:choose>
					<xsl:when test="head/author[2]">Auteurs&#xA0;: </xsl:when>
					<xsl:otherwise>Auteur&#xA0;: </xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates select="head/author" mode="footer"/>
				<xsl:text> - </xsl:text>
				<xsl:apply-templates select="head/revhistory/revision[1]/date"/>
			</td>
		</tr>
	</xsl:template>

	<!-- Processing of author information in the footer -->
	<xsl:template match="head/author" mode="footer">
		<xsl:if test="preceding-sibling::author">&#xA0;; </xsl:if>
		<xsl:apply-templates select="firstname"/>
		<xsl:text> </xsl:text>
		<xsl:apply-templates select="surname"/>
		<xsl:apply-templates select="affiliation"/>
	</xsl:template>

	<!-- Processing of affiliation -->
	<xsl:template match="affiliation">
		<xsl:text> (</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>)</xsl:text>
	</xsl:template>


</xsl:stylesheet>
