/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.util.OAIUtilities;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Apr 24, 2003
 * Time: 3:37:40 PM
 * To change this template use Options | File Templates.
 */

/**A base class for common variables/behaviors
 *
 */
public abstract class OAIObjectImpl extends AbstractXMLPipe implements OAIObject {

    /**The logger*/
    protected Logger logger = null;

    /**Establishes the logger
     *
     * @param logger
     */
    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    /**Sends a element with the simple character content
     * provided by the <code>elemContent</code> param
     *
     * @param uri   The namespace uri
     * @param localName The local name
     * @param qName The qualified name
     * @param atts The attributes
     * @param elemContent The character content
     * @throws SAXException
     */
    protected void sendElement(String uri, String localName, String qName, Attributes atts, String elemContent) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.sendElementContent(elemContent);
        super.endElement(uri, localName, qName);
    }


    /**Sends a start element event*/
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (atts == null) atts = new AttributesImpl();
        super.startElement(uri, localName, qName, atts);

    }

    /**Sends character content from the provided string
     *
     * @param content The string of characters to send
     */
    protected void sendElementContent(String content) throws SAXException {
        if (OAIUtilities.checkString(content)) {
            char[] chars = content.toCharArray();
            super.characters(chars, 0, chars.length);
        }

    }


}
