/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.utils.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.util.Stack;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Jul 15, 2003
 * Time: 6:14:48 PM
 * To change this template use Options | File Templates.
 */
/*
<sdx:transformation id="attLabElemStripper" type="fr.gouv.culture.sdx.sitemap.transformers.AttributeLabeledElementFilter">
    <!-- list of attribute names the parent sax events will be stripped-->
    <sdx:parameter name="field" value="http://www.culture.gouv.fr/ns/sdx/sdx"/>
    <sdx:parameter name="result" value="http://www.culture.gouv.fr/ns/sdx/sdx"/>
</sdx:transformation>

*/

public class AttributeLabeledElementFilter extends ElementFilter {

    Stack processedElements = new Stack();

    //TODO: add simple xpath format support for attributes and handle their values as well like <parameter name="/blah/sdx:blah/@blah" value="anyString"/>
    protected boolean shouldSendElementEvent(String uri, String loc, String raw, Attributes a) {
        if (a != null) {
            String[] attNames = super.transParameters.getNames();
            for (int i = 0; i < attNames.length; i++) {
                String attName = attNames[i];
                if (a.getIndex(attName) < 0)//not mapped send anyway
                    return super.withinFilteredElement(true);
                else {
                    String paramValue = super.transParameters.getParameter(attName, "");
                    String attValue = a.getValue(attName);
                    if (Utilities.checkString(paramValue) && Utilities.checkString(attValue)) {
                        if (!paramValue.equals(attValue))//value is what is mapped as a parameter
                            return super.withinFilteredElement(true);
                    }
                    //mapped as parameter send using mode
                    this.processedElements.push(super._xpathString.getQualifiedXPath().intern());
                    return super.withinFilteredElement(super._send);
                }
            }

            return super.shouldSendElementEvent(uri, loc, raw, a);
        } else
            return super.shouldSendElementEvent(uri, loc, raw, a);

    }

    public void endElement(String uri, String loc, String raw)
            throws SAXException {
        try {
            if (this.processedElements.contains(super._xpathString.getQualifiedXPath().intern()))
                this.processedElements.remove(super._xpathString.getQualifiedXPath().intern());
            else
                super.endElement(uri, loc, raw);

            resetCurrentElementProperties();
        } finally {
            this.resetProcessedElements();
        }

    }

    public void endDocument()
            throws SAXException {
        this.resetProcessedElements();
    }

    protected void resetProcessedElements() {
        this.processedElements = new Stack();//resetting the list of processed elements

    }


}
