/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.xml.SimpleXPathString;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Jul 9, 2003
 * Time: 2:19:34 PM
 * To change this template use Options | File Templates.
 */
public class TagFilter extends AbstractTransformation {
    /**Variable indicating wheter elements specified as in the transParameters object should be sent*/
    protected boolean _send = false;//defaulted
    protected String lastPrefixRemoved = null;
    protected String c_uri = "";
    protected String c_loc = "";
    protected String c_raw = "";
    protected Attributes c_atts = null;
    protected SimpleXPathString _xpathString = new SimpleXPathString();

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        setSendMode(super.transParameters);
    }

    protected void setSendMode(Parameters params) {
        if (params != null)
            this._send = params.getParameterAsBoolean("send", this._send);
    }

    protected void setCurrentElementProperties(String uri, String loc, String raw, Attributes atts) {
        this.c_uri = uri;
        this.c_loc = loc;
        this.c_raw = raw;
        this.c_atts = atts;
        if (Utilities.checkString(this.c_loc))
            _xpathString.concatLocalXPath(this.c_loc);
        if (Utilities.checkString(this.c_raw))
            _xpathString.concatQualifiedXPath(this.c_raw);
    }

    protected void resetCurrentElementProperties() {
        _xpathString.trimLocalXPath(this.c_loc);
        _xpathString.trimQualifiedXPath(this.c_raw);
        setCurrentElementProperties("", "", "", null);
    }


    public void startElement(String uri, String loc, String raw, Attributes a)
            throws SAXException {
        setCurrentElementProperties(uri, loc, raw, a);
        if (shouldSendElementEvent(uri, loc, raw, a))
            super.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw)
            throws SAXException {
        if (shouldSendElementEvent(uri, loc, raw, c_atts))
            super.endElement(uri, loc, raw);
        resetCurrentElementProperties();
    }

    protected boolean shouldSendElementEvent(String uri, String loc, String raw, Attributes a) {
        boolean send = !this._send;
        if (super.transParameters != null && (loc != null || uri != null)) {
            String mappedUri = "";
            String prefix = "";
            int colonIdx = raw.indexOf(":");
            if (colonIdx < 0)
                colonIdx = raw.length();
            prefix = raw.substring(0, colonIdx);

            //checking if the local name is specified as a parameter
            if (super.transParameters.isParameter(loc)) {
                send = this._send;
                mappedUri = super.transParameters.getParameter(loc, mappedUri);
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri))
                    send = !this._send;
            }
            //checking if the qualified name is specified as a parameter
            else if (super.transParameters.isParameter(raw)) {
                send = this._send;
                mappedUri = super.transParameters.getParameter(raw, mappedUri);
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri))
                    send = !this._send;
            }
            //checking if the simple xpath local name is specified as a parameter
            else if (super.transParameters.isParameter(_xpathString.getLocalXPath())) {
                send = this._send;
                mappedUri = super.transParameters.getParameter(_xpathString.getLocalXPath(), mappedUri);
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri))
                    send = !this._send;
            }
            //checking if the simple xpath qualified name is specified as a parameter
            else if (super.transParameters.isParameter(_xpathString.getQualifiedXPath())) {
                send = this._send;
                mappedUri = super.transParameters.getParameter(_xpathString.getQualifiedXPath(), mappedUri);
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri))
                    send = !this._send;
            }
            //checking if the prefix is specified as a parameter
            else if (super.transParameters.isParameter(prefix)) {
                send = this._send;
                mappedUri = super.transParameters.getParameter(prefix, "");
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri))
                    send = !this._send;
            }
            //checking if the uri is specified as a parameter
            else if (super.transParameters.isParameter(uri)) {
                send = this._send;
                String mappedPrefix = super.transParameters.getParameter(uri, "");
                if (Utilities.checkString(mappedPrefix) && !mappedPrefix.equals(prefix))
                    send = !this._send;
            }


        }
        return send;
    }


    public void startPrefixMapping(String prefix, String uri)
            throws SAXException {
        if (shouldSendElementEvent(uri, null, prefix, null))
            super.startPrefixMapping(prefix, uri);
        else
            lastPrefixRemoved = prefix;
    }

    public void endPrefixMapping(String prefix)
            throws SAXException {
        if (!prefix.equals(lastPrefixRemoved))
            super.endPrefixMapping(prefix);
        else
            lastPrefixRemoved = null;

    }



    /*
      public void setDocumentLocator(Locator locator) {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.setDocumentLocator(locator);
      }



      public void startPrefixMapping(String prefix, String uri)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.startPrefixMapping(prefix, uri);
      }

         public void endPrefixMapping(String prefix)
              throws SAXException {
              if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
                super.endPrefixMapping(prefix);
      }

      public void endPrefixMapping(String prefix)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.endPrefixMapping(prefix);
      }

      public void characters(char c[], int start, int len)
              throws SAXException {
          //always sending characters as this is a tag stripper
          super.characters(c, start, len);
      }

      public void ignorableWhitespace(char c[], int start, int len)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.ignorableWhitespace(c, start, len);
      }

      public void processingInstruction(String target, String data)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.processingInstruction(target, data);
      }

      public void skippedEntity(String name)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.skippedEntity(name);
      }

      public void startDTD(String name, String publicId, String systemId)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.startDTD(name, publicId, systemId);
      }

      public void endDTD()
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.endDTD();
      }

      public void startEntity(String name)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
          super.startEntity(name);
      }

      public void endEntity(String name)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))

          super.endEntity(name);
      }

      public void startCDATA()
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
          super.startCDATA();
      }

      public void endCDATA()
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
          super.endCDATA();
      }

      public void comment(char ch[], int start, int len)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))

          super.comment(ch, start, len);
      }
      */
}
