package fr.gouv.culture.sdx.user;

/**
 * Represents a superuser, which is a user who can manage the SDX
 * server. This class extends overrides UserInformation by returning
 * true for the isAdmin() and isSuperuser() methods.
 */
public class SuperuserInformation extends UserInformation {
    /**
     * Returns whether this user can admin an application.
     *
     * <p>For the superuser, it always returns <code>true</code>.
     *
     * @param   app     The application id.
     */
    public boolean isAdmin(String app) {
        return true;
    }

    /**
     * Returns whether this user is a superuser.
     *
     * <p>Always return <code>true</code>.
     */
    public boolean isSuperuser() {
        return true;
    }

    /**
     * Return whether this user is member of some groups.
     *
     * <p>Returns <code>false</code>.
     * @param   groupnames      The list of groups.
     * @param   all             If <code>true</code>, the user must be a member of each groups ; otherwise a member of at least one of them.
     */
    public boolean isMember(String[] groupnames, boolean all) {
        return false;
    }

    /**
     * Returns whether this user is a member of at least one of the groups. This method
     * is a shortcut for isMember(groupnames, false).
     *
     * <p>Returns false.
     *
     * @param   groupnames      The list of group names.
     */
    public boolean isMember(String[] groupnames) {
        return false;
    }

    /**
     * Returns whether this user is a member of a group.
     *
     * <p>Returns <code>false</code>.
     *
     * @param   groupname       The name of the group.
     */
    public boolean isMember(String groupname) {
        return false;
    }
}
