/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import com.icl.saxon.Context;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.StandaloneContext;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.tinytree.TinyBuilder;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.xpath.AbstractProcessorImpl;
import org.apache.excalibur.xml.xpath.NodeListImpl;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Saxon6ProcessorImpl
extends AbstractProcessorImpl
implements XPathProcessor,
Component,
ThreadSafe {
    private static final TransformerFactory factory = new TransformerFactoryImpl();

    public boolean evaluateAsBoolean(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Value value = this.evaluate(contextNode, str, resolver);
            if (value == null) {
                return false;
            }
            return value.asBoolean();
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Value value = this.evaluate(contextNode, str, resolver);
            if (value == null) {
                return null;
            }
            return new Double(value.asNumber());
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Value value = this.evaluate(contextNode, str, resolver);
            if (value == null) {
                return null;
            }
            return value.asString();
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public Node selectSingleNode(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Value value = this.evaluate(contextNode, str, resolver);
            if (value == null || value.getDataType() != 4) {
                return null;
            }
            return (Node)((NodeSetValue)value).getFirst();
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Value value = this.evaluate(contextNode, str, resolver);
            if (value.getDataType() != 4) {
                return null;
            }
            NodeSetValue nodeset = (NodeSetValue)value;
            NodeEnumeration enumeration = nodeset.enumerate();
            Node[] nodes = new Node[nodeset.getCount()];
            int i = 0;
            while (i < nodes.length) {
                nodes[i] = (Node)enumeration.nextElement();
                ++i;
            }
            return new NodeListImpl(nodes);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    private Value evaluate(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DocumentInfo doc;
            NamePool pool;
            if (!(contextNode instanceof NodeInfo)) {
                this.getLogger().debug("Input tree is not SAXON TinyTree, converting");
                DOMSource source = new DOMSource(contextNode);
                TinyBuilder result = new TinyBuilder();
                factory.newTransformer().transform(source, (Result)result);
                contextNode = (Node)result.getCurrentDocument();
            }
            if ((pool = (doc = ((NodeInfo)contextNode).getDocumentRoot()).getNamePool()) == null) {
                pool = NamePool.getDefaultNamePool();
                doc.setNamePool(pool);
            }
            Expression expression = Expression.make((String)str, (StaticContext)new Saxon6Context(pool, resolver));
            Context context = new Context();
            context.setContextNode((NodeInfo)contextNode);
            context.setPosition(1);
            context.setLast(1);
            return expression.evaluate(context);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    private class Saxon6Context
    extends StandaloneContext {
        private final PrefixResolver resolver;

        public Saxon6Context(NamePool namePool, PrefixResolver resolver) {
            super(namePool);
            this.resolver = resolver;
        }

        public String getURIForPrefix(String prefix) throws XPathException {
            return this.resolver.prefixToNamespace(prefix);
        }
    }
}

