/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.xpath.AbstractProcessorImpl;
import org.apache.excalibur.xml.xpath.EmptyNodeList;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathProcessorImpl
extends AbstractProcessorImpl
implements XPathProcessor,
Configurable,
Component,
ThreadSafe {
    private String m_baseURI;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        Configuration namespaceMappings = configuration.getChild("namespace-mappings", true);
        this.m_baseURI = namespaceMappings.getAttribute("base-uri", null);
    }

    public boolean evaluateAsBoolean(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.bool();
        }
        catch (TransformerException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return new Double(result.num());
        }
        catch (TransformerException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.str();
        }
        catch (TransformerException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public Node selectSingleNode(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.nodeset().nextNode();
        }
        catch (TransformerException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str, PrefixResolver resolver) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (org.apache.xml.utils.PrefixResolver)new XalanResolver(resolver));
            return result.nodelist();
        }
        catch (TransformerException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return new EmptyNodeList();
        }
    }

    private final class XalanResolver
    implements org.apache.xml.utils.PrefixResolver {
        private final PrefixResolver resolver;

        public XalanResolver(PrefixResolver resolver) {
            this.resolver = resolver;
        }

        public String getNamespaceForPrefix(String prefix) {
            return this.resolver.prefixToNamespace(prefix);
        }

        public String getNamespaceForPrefix(String prefix, Node context) {
            return this.resolver.prefixToNamespace(prefix);
        }

        public String getBaseIdentifier() {
            return XPathProcessorImpl.this.m_baseURI;
        }

        public boolean handlesNullPrefixes() {
            return false;
        }
    }
}

