/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.javagroups;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.RspList;

public class JavaGroupsCache
implements AuxiliaryCache,
RequestHandler,
MembershipListener {
    private final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache == null ? (class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache = JavaGroupsCache.class$("org.apache.jcs.auxiliary.javagroups.JavaGroupsCache")) : class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache));
    private String cacheName;
    private int status;
    private boolean getFromPeers;
    private CompositeCache cache;
    private Channel channel;
    private MessageDispatcher dispatcher;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache;

    public JavaGroupsCache(CompositeCache cache, Channel channel, boolean getFromPeers) throws Exception {
        this.cache = cache;
        this.cacheName = cache.getCacheName();
        this.channel = channel;
        this.getFromPeers = getFromPeers;
        this.dispatcher = new MessageDispatcher(channel, null, (MembershipListener)this, (RequestHandler)this);
        channel.setOpt(3, (Object)Boolean.FALSE);
        channel.connect(this.cacheName);
        this.status = 1;
        this.log.info((Object)("Initialized for cache: " + this.cacheName));
    }

    public void send(ICacheElement element, int command) {
        Request request = new Request(element, command);
        try {
            this.dispatcher.castMessage(null, new Message(null, null, (Serializable)request), 6, 0L);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to send JavaGroups message", (Throwable)e);
        }
    }

    public void update(ICacheElement ce) throws IOException {
        this.send(ce, 1);
    }

    public ICacheElement get(Serializable key) throws IOException {
        CacheElement element;
        Request request;
        RspList responses;
        Vector results;
        if (this.getFromPeers && (results = (responses = this.dispatcher.castMessage(null, new Message(null, null, (Serializable)(request = new Request(element = new CacheElement(this.cacheName, key, null), 5))), 2, 0L)).getResults()).size() > 0) {
            return (ICacheElement)results.get(0);
        }
        return null;
    }

    public boolean remove(Serializable key) throws IOException {
        CacheElement ce = new CacheElement(this.cacheName, key, null);
        this.send(ce, 2);
        return false;
    }

    public void removeAll() throws IOException {
        CacheElement ce = new CacheElement(this.cacheName, null, null);
        this.send(ce, 3);
    }

    public void dispose() throws IOException {
        this.dispatcher.stop();
        this.channel.disconnect();
        this.channel.close();
        this.status = 2;
        this.log.info((Object)("Disposed for cache: " + this.cacheName));
    }

    public int getSize() {
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Set getGroupKeys(String group) {
        return null;
    }

    public int getCacheType() {
        return 3;
    }

    public Object handle(Message msg) {
        try {
            Request request = (Request)msg.getObject();
            switch (request.getCommand()) {
                case 5: {
                    return this.cache.localGet(request.getCacheElement().getKey());
                }
                case 1: {
                    this.cache.localUpdate(request.getCacheElement());
                    break;
                }
                case 2: {
                    this.cache.localRemove(request.getCacheElement().getKey());
                    break;
                }
                case 3: {
                    this.cache.localRemoveAll();
                    break;
                }
                default: {
                    this.log.error((Object)"Recieved unknown command");
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to process received JavaGroups message", (Throwable)e);
        }
        return null;
    }

    public void viewAccepted(View view) {
        this.log.info((Object)("View Changed: " + String.valueOf(view)));
    }

    public void suspect(Address suspectedAddress) {
    }

    public void block() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Request
    implements Serializable {
        public static final int UPDATE = 1;
        public static final int REMOVE = 2;
        public static final int REMOVE_ALL = 3;
        public static final int GET = 5;
        private ICacheElement cacheElement;
        private int command;

        public Request(ICacheElement cacheElement, int command) {
            this.cacheElement = cacheElement;
            this.command = command;
        }

        public ICacheElement getCacheElement() {
            return this.cacheElement;
        }

        public int getCommand() {
            return this.command;
        }
    }
}

