/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.persistence.ConverterException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.portal.util.ReferenceFieldHandler;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class CastorSourceConverter
extends AbstractLogEnabled
implements Component,
Serviceable,
Configurable,
Initializable,
ThreadSafe {
    public static final String ROLE = (class$org$apache$cocoon$components$persistence$CastorSourceConverter == null ? (class$org$apache$cocoon$components$persistence$CastorSourceConverter = CastorSourceConverter.class$("org.apache.cocoon.components.persistence.CastorSourceConverter")) : class$org$apache$cocoon$components$persistence$CastorSourceConverter).getName();
    private Map mappingSources = new HashMap();
    private ServiceManager manager;
    private Map mappings = new HashMap();
    static /* synthetic */ Class class$org$apache$cocoon$components$persistence$CastorSourceConverter;

    public Object getObject(InputStream stream, Map parameters) throws ConverterException {
        try {
            ReferenceFieldHandler.setObjectMap((Map)parameters.get("objectmap"));
            Unmarshaller unmarshaller = new Unmarshaller((Mapping)this.mappings.get(parameters.get("profiletype")));
            Object result = unmarshaller.unmarshal(new InputSource(stream));
            stream.close();
            return result;
        }
        catch (MappingException e) {
            throw new ConverterException("can't create Unmarshaller", e);
        }
        catch (Exception e) {
            throw new ConverterException(e.getMessage(), e);
        }
    }

    public void storeObject(OutputStream stream, Map parameters, Object object) throws ConverterException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMapping((Mapping)this.mappings.get(parameters.get("profiletype")));
            marshaller.marshal(object);
            ((Writer)writer).close();
        }
        catch (MappingException e) {
            throw new ConverterException("can't create Unmarshaller", e);
        }
        catch (Exception e) {
            throw new ConverterException(e.getMessage(), e);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void configure(Configuration config) throws ConfigurationException {
        Configuration[] children = config.getChildren("mapping-source");
        int i = 0;
        while (i < children.length) {
            Configuration mappingSource = children[i];
            this.mappingSources.put(mappingSource.getAttribute("source"), mappingSource.getValue());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        SourceResolver resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        Source source = null;
        try {
            Iterator iterator = this.mappingSources.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                String mappingSource = (String)entry.getValue();
                source = resolver.resolveURI(mappingSource);
                Mapping mapping = new Mapping();
                mapping.loadMapping(SourceUtil.getInputSource((Source)source));
                this.mappings.put(name, mapping);
            }
        }
        finally {
            if (source != null) {
                resolver.release(source);
            }
            this.manager.release((Object)resolver);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

