/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.acting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.portal.PortalManager;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.acting.helpers.CopletMapping;
import org.apache.cocoon.portal.acting.helpers.LayoutMapping;
import org.apache.cocoon.portal.acting.helpers.Mapping;
import org.apache.cocoon.portal.event.Event;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BookmarkAction
extends ServiceableAction
implements ThreadSafe,
Parameterizable {
    protected Map eventMap = new HashMap();
    protected String historyParameterName;

    public void parameterize(Parameters parameters) throws ParameterException {
        Configuration config;
        this.historyParameterName = parameters.getParameter("history-parameter-name", "history");
        String configurationFile = parameters.getParameter("src", null);
        if (configurationFile == null) {
            return;
        }
        SourceResolver resolver = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                Source source = null;
                try {
                    try {
                        source = resolver.resolveURI(configurationFile);
                        SAXConfigurationHandler handler = new SAXConfigurationHandler();
                        SourceUtil.toSAX((Source)source, (ContentHandler)handler);
                        config = handler.getConfiguration();
                    }
                    catch (ProcessingException se) {
                        throw new ParameterException("Unable to read configuration from " + configurationFile, (Throwable)se);
                    }
                    catch (SAXException se) {
                        throw new ParameterException("Unable to read configuration from " + configurationFile, (Throwable)se);
                    }
                    catch (IOException ioe) {
                        throw new ParameterException("Unable to read configuration from " + configurationFile, (Throwable)ioe);
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    resolver.release(source);
                    throw throwable;
                }
                resolver.release(source);
                Object var12_19 = null;
            }
            catch (ServiceException se) {
                throw new ParameterException("Unable to lookup source resolver.", (Throwable)se);
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            this.manager.release((Object)resolver);
            throw throwable;
        }
        this.manager.release((Object)resolver);
        Configuration[] events = config.getChild("events").getChildren("event");
        if (events != null) {
            int i = 0;
            while (i < events.length) {
                block21: {
                    try {
                        Mapping mapping;
                        String type = events[i].getAttribute("type");
                        String id = events[i].getAttribute("id");
                        if (!"jxpath".equals(type)) {
                            throw new ParameterException("Unknown event type for event " + id + ": " + type);
                        }
                        if (this.eventMap.containsKey(id)) {
                            throw new ParameterException("The id for the event " + id + " is not unique.");
                        }
                        String targetType = events[i].getChild("targettype").getValue();
                        String targetId = events[i].getChild("targetid").getValue();
                        String path = events[i].getChild("path").getValue();
                        if ("layout".equals(targetType)) {
                            mapping = new LayoutMapping();
                            mapping.layoutId = targetId;
                            mapping.path = path;
                            this.eventMap.put(id, mapping);
                            break block21;
                        }
                        if ("coplet".equals(targetType)) {
                            mapping = new CopletMapping();
                            ((CopletMapping)mapping).copletId = targetId;
                            ((CopletMapping)mapping).path = path;
                            this.eventMap.put(id, mapping);
                            break block21;
                        }
                        throw new ParameterException("Unknown target type " + targetType);
                    }
                    catch (ConfigurationException ce) {
                        throw new ParameterException("Configuration exception", (Throwable)ce);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map act(Redirector redirector, org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String source, Parameters par) throws Exception {
        HashMap<String, String> result;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN act resolver=" + resolver + ", objectModel=" + objectModel + ", source=" + source + ", par=" + par);
        }
        PortalService service = null;
        try {
            try {
                int index;
                List state;
                List history;
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                service.setPortalName(par.getParameter("portal-name"));
                PortalManager portalManager = null;
                try {
                    portalManager = (PortalManager)this.manager.lookup(PortalManager.ROLE);
                    portalManager.process();
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    this.manager.release((Object)portalManager);
                    throw throwable;
                }
                this.manager.release((Object)portalManager);
                Request request = ObjectModelHelper.getRequest((Map)objectModel);
                Session session = request.getSession(false);
                ArrayList<Event> events = new ArrayList<Event>();
                String historyValue = request.getParameter(this.historyParameterName);
                if (historyValue != null && session != null && (history = (List)session.getAttribute("portal-history")) != null && (state = (List)history.get(index = Integer.parseInt(historyValue))) != null) {
                    Iterator iter = state.iterator();
                    while (iter.hasNext()) {
                        Mapping m = (Mapping)iter.next();
                        events.add(m.getEvent(service, null));
                    }
                    while (history.size() > index) {
                        history.remove(history.size() - 1);
                    }
                }
                Enumeration enumeration = request.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    String value = request.getParameter(name);
                    Mapping m = (Mapping)this.eventMap.get(name);
                    if (m == null) continue;
                    events.add(m.getEvent(service, value));
                }
                String uri = service.getComponentManager().getLinkService().getLinkURI(events);
                result = new HashMap<String, String>();
                result.put("uri", uri.substring(uri.indexOf(63) + 1));
            }
            catch (ParameterException pe) {
                throw new ProcessingException("Parameter portal-name is required.");
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup portal service.", (Throwable)ce);
            }
            Object var19_24 = null;
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)service);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END act map={}");
        }
        return result;
    }
}

