/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.application;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.portal.application.PortalApplicationConfig;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PortalApplicationConfigFactory {
    private static PortalApplicationConfigFactory instance = null;
    private Map portalAppConfigs = new HashMap();
    private SourceResolver resolver = null;

    private PortalApplicationConfigFactory() {
    }

    public static synchronized PortalApplicationConfigFactory getInstance(SourceResolver resolver) throws ProcessingException {
        if (instance == null) {
            instance = new PortalApplicationConfigFactory();
            PortalApplicationConfigFactory.instance.resolver = resolver;
            PortalApplicationConfigFactory.createConfig();
        }
        return instance;
    }

    private static void createConfig() throws ProcessingException {
        try {
            NodeList apps = PortalApplicationConfigFactory.getApplicationList();
            int i = 0;
            while (i < apps.getLength()) {
                Element e = (Element)apps.item(i);
                String copletId = e.getAttribute("copletId");
                PortalApplicationConfig cfg = new PortalApplicationConfig(e);
                PortalApplicationConfigFactory.instance.portalAppConfigs.put(copletId, cfg);
                ++i;
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Could not create PortalApplicationConfiguration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeList getApplicationList() throws Exception {
        NodeList nodeList;
        Source s = PortalApplicationConfigFactory.instance.resolver.resolveURI("profiles/applications/application-coplet-binding.xml");
        try {
            NodeList apps;
            Document doc = SourceUtil.toDOM((Source)s);
            nodeList = apps = doc.getDocumentElement().getElementsByTagName("application");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PortalApplicationConfigFactory.instance.resolver.release(s);
            throw throwable;
        }
        PortalApplicationConfigFactory.instance.resolver.release(s);
        return nodeList;
    }

    public PortalApplicationConfig getConfig(String copletId) throws ProcessingException {
        PortalApplicationConfig cfg = (PortalApplicationConfig)this.portalAppConfigs.get(copletId);
        cfg = "???".equals(copletId) ? this.getSpecialConfig(copletId) : (PortalApplicationConfig)this.portalAppConfigs.get(copletId);
        if (cfg == null) {
            throw new ProcessingException("No PortalApplicationConfig available for coplet " + copletId + ".");
        }
        return cfg;
    }

    private PortalApplicationConfig getSpecialConfig(String specialId) throws ProcessingException {
        try {
            NodeList apps = PortalApplicationConfigFactory.getApplicationList();
            int i = 0;
            while (i < apps.getLength()) {
                Element e = (Element)apps.item(i);
                String copletId = e.getAttribute("copletId");
                if (specialId.equals(copletId)) {
                    return new PortalApplicationConfig(e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Error while getting configuration for special coplet");
        }
        return null;
    }
}

