/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.event.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.event.Event;
import org.apache.cocoon.portal.event.EventConverter;
import org.apache.cocoon.portal.event.EventManager;
import org.apache.cocoon.portal.event.Publisher;
import org.apache.cocoon.portal.event.Register;
import org.apache.cocoon.portal.event.Subscriber;
import org.apache.cocoon.portal.event.aspect.EventAspect;
import org.apache.cocoon.portal.event.impl.DefaultEventAspectContext;
import org.apache.cocoon.portal.event.impl.EventAspectChain;
import org.apache.cocoon.util.ClassUtils;

public class DefaultEventManager
extends AbstractLogEnabled
implements EventManager,
Serviceable,
Initializable,
ThreadSafe,
Configurable,
Disposable,
Contextualizable,
Publisher,
Register {
    private final String rootEventType = (class$org$apache$cocoon$portal$event$Event == null ? (class$org$apache$cocoon$portal$event$Event = DefaultEventManager.class$("org.apache.cocoon.portal.event.Event")) : class$org$apache$cocoon$portal$event$Event).getName();
    private Class eventClass;
    private List subscribers = new ArrayList();
    private ServiceManager manager;
    private Configuration configuration;
    protected EventAspectChain chain;
    protected ServiceSelector aspectSelector;
    protected Context context;
    static /* synthetic */ Class class$org$apache$cocoon$portal$event$Event;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public Publisher getPublisher() {
        return this;
    }

    public Register getRegister() {
        return this;
    }

    protected Map getObjectModel() {
        return ContextHelper.getObjectModel((Context)this.context);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.configuration = conf;
    }

    public void dispose() {
        if (this.manager != null) {
            if (this.chain != null) {
                this.chain.dispose(this.aspectSelector);
            }
            this.manager.release((Object)this.aspectSelector);
            this.aspectSelector = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        Configuration[] classesConf;
        Configuration classes;
        Configuration[] rolesConf;
        Configuration roles;
        this.eventClass = Class.forName(this.rootEventType);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Initialising eventClass " + this.eventClass);
        }
        if ((roles = this.configuration.getChild("subscriber-roles", false)) != null && (rolesConf = roles.getChildren("role")) != null) {
            int i = 0;
            while (i < rolesConf.length) {
                Object var8_9;
                Configuration current = rolesConf[i];
                String name = current.getAttribute("name");
                Subscriber subscriber = null;
                try {
                    subscriber = (Subscriber)this.manager.lookup(name);
                    this.subscribe(subscriber);
                    var8_9 = null;
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    this.manager.release((Object)subscriber);
                    throw throwable;
                }
                this.manager.release((Object)subscriber);
                ++i;
            }
        }
        if ((classes = this.configuration.getChild("subscriber-classes", false)) != null && (classesConf = classes.getChildren("class")) != null) {
            int i = 0;
            while (i < classesConf.length) {
                Configuration current = classesConf[i];
                String name = current.getAttribute("name");
                Subscriber subscriber = (Subscriber)ClassUtils.newInstance((String)name);
                ContainerUtil.enableLogging((Object)subscriber, (Logger)this.getLogger());
                ContainerUtil.service((Object)subscriber, (ServiceManager)this.manager);
                ContainerUtil.initialize((Object)subscriber);
                this.subscribe(subscriber);
                ++i;
            }
        }
    }

    public void publish(Event event) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Publishing event " + event.getClass());
        }
        Iterator e = this.subscribers.iterator();
        while (e.hasNext()) {
            Subscriber subscriber = (Subscriber)e.next();
            if (!subscriber.getEventType().isAssignableFrom(event.getClass()) || subscriber.getFilter() != null && !subscriber.getFilter().filter(event)) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().info("Informing subscriber " + subscriber + " of event " + event.getClass());
            }
            subscriber.inform(event);
        }
    }

    public void subscribe(Subscriber subscriber) {
        if (!this.eventClass.isAssignableFrom(subscriber.getEventType())) {
            throw new RuntimeException("Invalid event type " + subscriber.getEventType() + " for subscriber " + subscriber);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Subscribing event " + subscriber.getEventType().getName());
        }
        if (!this.subscribers.contains(subscriber)) {
            this.subscribers.add(subscriber);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Subscribed Event " + subscriber.getEventType().getName());
                this.getLogger().debug("Subscribers now active: " + this.subscribers.size());
            }
        }
    }

    public void unsubscribe(Subscriber subscriber) {
        if (!this.eventClass.isAssignableFrom(subscriber.getEventType())) {
            throw new RuntimeException("Invalid event type " + subscriber.getEventType() + " for unsubscribing " + subscriber);
        }
        if (this.subscribers.contains(subscriber)) {
            this.subscribers.remove(subscriber);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Unsubscribed Event " + subscriber.getEventType().getName());
                this.getLogger().debug("Subscribers now active: " + this.subscribers.size());
            }
        } else {
            this.getLogger().warn("Subscriber " + subscriber + " not found");
        }
    }

    public void processEvents() throws ProcessingException {
        if (this.configuration != null) {
            try {
                this.aspectSelector = (ServiceSelector)this.manager.lookup(EventAspect.ROLE + "Selector");
                this.chain = new EventAspectChain();
                this.chain.configure(this.aspectSelector, this.configuration.getChild("event-aspects"));
            }
            catch (ConfigurationException ce) {
                throw new ProcessingException("Unable configure component.", (Throwable)ce);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup component.", (Throwable)ce);
            }
            this.configuration = null;
        }
        DefaultEventAspectContext context = new DefaultEventAspectContext(this.chain);
        EventConverter converter = null;
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                converter = (EventConverter)this.manager.lookup(EventConverter.ROLE);
                Publisher publisher = this.getPublisher();
                converter.start();
                context.setEventPublisher(publisher);
                context.setObjectModel(this.getObjectModel());
                context.setEventConverter(converter);
                context.invokeNext(service);
                converter.finish();
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup component.", (Throwable)ce);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.manager.release(converter);
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)converter);
        this.manager.release((Object)service);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

