/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.event.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;

public final class EventAspectChain {
    private List aspects = new ArrayList();
    private List configs = new ArrayList();

    public void configure(ServiceSelector selector, Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration[] aspects = conf.getChildren("aspect");
            if (aspects != null) {
                int i = 0;
                while (i < aspects.length) {
                    Configuration current = aspects[i];
                    String role = current.getAttribute("type");
                    try {
                        this.aspects.add(selector.select((Object)role));
                        this.configs.add(Parameters.fromConfiguration((Configuration)current));
                    }
                    catch (ServiceException se) {
                        throw new ConfigurationException("Unable to lookup aspect " + role, (Throwable)se);
                    }
                    ++i;
                }
            }
        } else {
            throw new ConfigurationException("No aspects configured");
        }
    }

    public Iterator getIterator() {
        return this.aspects.iterator();
    }

    public Iterator getConfigIterator() {
        return this.configs.iterator();
    }

    public void dispose(ServiceSelector selector) {
        Iterator i = this.aspects.iterator();
        while (i.hasNext()) {
            selector.release(i.next());
        }
        this.aspects.clear();
    }
}

