/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.layout.Item;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.AbstractCompositeAspect;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CompositeContentAspect
extends AbstractCompositeAspect {
    protected static final String ITEM_STRING = "item";

    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        PreparedConfiguration config = (PreparedConfiguration)context.getAspectConfiguration();
        if (config.rootTag) {
            XMLUtils.startElement((ContentHandler)handler, (String)config.tagName);
        }
        super.toSAX(context, layout, service, handler);
        if (config.rootTag) {
            XMLUtils.endElement((ContentHandler)handler, (String)config.tagName);
        }
    }

    protected void processItem(Item item, ContentHandler handler, PortalService service) throws SAXException {
        Layout layout = item.getLayout();
        Map parameters = item.getParameters();
        if (parameters.size() == 0) {
            XMLUtils.startElement((ContentHandler)handler, (String)ITEM_STRING);
        } else {
            AttributesImpl attributes = new AttributesImpl();
            Iterator iter = parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                attributes.addCDATAAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            XMLUtils.startElement((ContentHandler)handler, (String)ITEM_STRING, (Attributes)attributes);
        }
        this.processLayout(layout, service, handler);
        XMLUtils.endElement((ContentHandler)handler, (String)ITEM_STRING);
    }

    public Object prepareConfiguration(Parameters configuration) throws ParameterException {
        PreparedConfiguration pc = new PreparedConfiguration();
        pc.tagName = configuration.getParameter("tag-name", "composite");
        pc.rootTag = configuration.getParameterAsBoolean("root-tag", true);
        return pc;
    }

    protected class PreparedConfiguration {
        public String tagName;
        public boolean rootTag;

        protected PreparedConfiguration() {
        }

        public void takeValues(PreparedConfiguration from) {
            this.tagName = from.tagName;
            this.rootTag = from.rootTag;
        }
    }
}

