/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.pluto;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.cocoon.Constants;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.pluto.services.information.PortalContextProvider;

public class PortalContextProviderImpl
implements PortalContextProvider {
    protected String info;
    protected Vector modes = this.getDefaultModes();
    protected Vector states = this.getDefaultStates();
    protected HashMap properties;
    protected String hostNameHTTP;
    protected String hostNameHTTPS;
    protected String contextHTTP;
    protected String contextHTTPS;

    public PortalContextProviderImpl(Map objectModel) {
        this.info = "Apache Cocoon/" + Constants.VERSION;
        this.properties = new HashMap();
        this.init(objectModel);
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        return (String)this.properties.get(name);
    }

    public Collection getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection getSupportedPortletModes() {
        return this.modes;
    }

    public Collection getSupportedWindowStates() {
        return this.states;
    }

    public String getPortalInfo() {
        return this.info;
    }

    protected Vector getDefaultModes() {
        Vector<PortletMode> m = new Vector<PortletMode>();
        m.add(new PortletMode("view"));
        m.add(new PortletMode("edit"));
        m.add(new PortletMode("help"));
        m.add(new PortletMode("config"));
        return m;
    }

    protected Vector getDefaultStates() {
        Vector<WindowState> s = new Vector<WindowState>();
        s.add(new WindowState("normal"));
        s.add(new WindowState("minimized"));
        s.add(new WindowState("maximized"));
        return s;
    }

    protected void init(Map objectModel) {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String hostName = request.getServerName();
        String contextRoot = request.getContextPath();
        int hostPortHTTP = request.getServerPort();
        int hostPortHTTPS = 443;
        StringBuffer hostHTTP = new StringBuffer("http://");
        hostHTTP.append(hostName);
        if (hostPortHTTP != 80) {
            hostHTTP.append(":");
            hostHTTP.append(hostPortHTTP);
        }
        this.hostNameHTTP = hostHTTP.toString();
        hostHTTP.append('/');
        hostHTTP.append(contextRoot);
        this.contextHTTP = hostHTTP.toString();
        StringBuffer hostHTTPS = new StringBuffer("https://");
        hostHTTPS.append(hostName);
        this.hostNameHTTPS = hostHTTPS.toString();
        hostHTTPS.append('/');
        hostHTTPS.append(contextRoot);
        this.contextHTTPS = hostHTTPS.toString();
    }

    public String getBaseURLexcludeContext(boolean secure) {
        return secure ? this.hostNameHTTPS : this.hostNameHTTP;
    }

    public String getBaseURL(boolean secure) {
        return secure ? this.contextHTTPS : this.contextHTTP;
    }
}

