/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portlet.multipart;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.portlet.ActionRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import org.apache.cocoon.servlet.multipart.PartOnDisk;

public class MultipartActionRequest
implements ActionRequest {
    private ActionRequest request = null;
    private Hashtable values = null;

    public MultipartActionRequest(ActionRequest request, Hashtable values) {
        this.request = request;
        this.values = values;
    }

    public void cleanup() throws IOException {
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            Object o = this.get((String)e.nextElement());
            if (!(o instanceof PartOnDisk)) continue;
            File file = ((PartOnDisk)o).getFile();
            file.delete();
        }
    }

    public Object get(String name) {
        Vector<String> result = null;
        if (this.values != null && (result = (Vector<String>)this.values.get(name)) instanceof Vector) {
            if (((Vector)result).size() == 1) {
                return ((Vector)result).elementAt(0);
            }
            return result;
        }
        if (result == null) {
            String[] array = this.request.getParameterValues(name);
            Vector<String> vec = new Vector<String>();
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    vec.addElement(array[i]);
                    ++i;
                }
                result = vec.size() == 1 ? vec.elementAt(0) : vec;
            }
        }
        return result;
    }

    public Enumeration getParameterNames() {
        if (this.values != null) {
            return this.values.keys();
        }
        return this.request.getParameterNames();
    }

    public String getParameter(String name) {
        Object value = this.get(name);
        String result = null;
        if (value != null) {
            if (value instanceof Vector) {
                value = ((Vector)value).elementAt(0);
            }
            result = value.toString();
        }
        return result;
    }

    public String[] getParameterValues(String name) {
        if (this.values != null) {
            Object value = this.get(name);
            if (value != null) {
                if (value instanceof Vector) {
                    String[] results = new String[((Vector)value).size()];
                    int i = 0;
                    while (i < ((Vector)value).size()) {
                        results[i] = ((Vector)value).elementAt(i).toString();
                        ++i;
                    }
                    return results;
                }
                return new String[]{value.toString()};
            }
            return null;
        }
        return this.request.getParameterValues(name);
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getPortletInputStream();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public PortletSession getPortletSession(boolean create) {
        return this.request.getPortletSession(create);
    }

    public PortletSession getPortletSession() {
        return this.request.getPortletSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public InputStream getPortletInputStream() throws IOException {
        return this.request.getPortletInputStream();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(enc);
    }

    public Map getParameterMap() {
        return this.request.getParameterMap();
    }

    public PortalContext getPortalContext() {
        return this.request.getPortalContext();
    }

    public PortletMode getPortletMode() {
        return this.request.getPortletMode();
    }

    public PortletPreferences getPreferences() {
        return this.request.getPreferences();
    }

    public Enumeration getProperties(String name) {
        return this.request.getProperties(name);
    }

    public String getProperty(String name) {
        return this.request.getProperty(name);
    }

    public Enumeration getPropertyNames() {
        return this.request.getPropertyNames();
    }

    public String getResponseContentType() {
        return this.request.getResponseContentType();
    }

    public Enumeration getResponseContentTypes() {
        return this.request.getResponseContentTypes();
    }

    public WindowState getWindowState() {
        return this.request.getWindowState();
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        return this.request.isPortletModeAllowed(mode);
    }

    public boolean isWindowStateAllowed(WindowState state) {
        return this.request.isWindowStateAllowed(state);
    }
}

