/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.Version;
import org.mortbay.http.ajp.AJP13InputStream;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.http.ajp.AJP13OutputStream;
import org.mortbay.util.Code;
import org.mortbay.util.LineInput;

public class AJP13Connection
extends HttpConnection {
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener listener, InputStream in, OutputStream out, Socket socket, int bufferSize) throws IOException {
        super(listener, null, new AJP13InputStream(in, out, bufferSize), out, socket);
        LineInput lin = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lin.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getFilterStream(), bufferSize);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut, true);
        this._listener = listener;
    }

    public InetAddress getRemoteInetAddress() {
        return null;
    }

    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        block69: {
            block62: {
                block68: {
                    block60: {
                        packet = null;
                        request = this.getRequest();
                        response = this.getResponse();
                        context = null;
                        gotRequest = false;
                        this._persistent = true;
                        this._keepAlive = true;
                        try {
                            block64: {
                                block61: {
                                    try {
                                        packet = null;
                                        packet = this._ajpIn.nextPacket();
                                        if (packet == null) {
                                            var6_6 = false;
                                            var16_10 = null;
                                            if (packet == null) return false;
                                            if (!gotRequest) {
                                                return false;
                                            }
                                            break block60;
                                        }
                                        if (packet.getDataSize() != 0) break block61;
                                        var7_38 = true;
                                        break block62;
                                    }
                                    catch (IOException e) {
                                        Code.ignore(e);
                                        var7_39 = false;
                                        var16_12 = null;
                                        if (packet == null) return false;
                                        if (!gotRequest) {
                                            return false;
                                        }
                                        try {
                                            try {
                                                this.getOutputStream().close();
                                                if (!this._persistent) {
                                                    this._ajpOut.end();
                                                }
                                                this._ajpOut.close();
                                                this.getOutputStream().resetStream();
                                                this.getOutputStream().addObserver(this);
                                                this.getInputStream().resetStream();
                                                this._ajpIn.resetStream();
                                                this._ajpOut.resetStream();
                                                v0 = null;
                                            }
                                            catch (Exception e) {
                                                Code.debug(e);
                                                this._persistent = false;
                                                v0 = null;
                                            }
                                        }
                                        catch (Throwable var18_26) {
                                            v0 = null;
                                        }
                                        var19_33 = v0;
                                        this.statsRequestEnd();
                                        if (context == null) return var7_39;
                                        context.log(request, response, -1);
                                        return var7_39;
                                    }
                                }
                                type = packet.getByte();
                                if (Code.debug()) {
                                    Code.debug("AJP13 type=" + type + " size=" + packet.unconsumedData());
                                }
                                switch (type) {
                                    case 2: {
                                        request.setTimeStamp(System.currentTimeMillis());
                                        request.setState(0);
                                        request.setMethod(packet.getMethod());
                                        request.setVersion(packet.getString());
                                        request.setPath(packet.getString());
                                        this._remoteAddr = packet.getString();
                                        this._remoteHost = packet.getString();
                                        this._serverName = packet.getString();
                                        this._serverPort = packet.getInt();
                                        this._isSSL = packet.getBoolean();
                                        this._keepAlive = request.getDotVersion() >= 1;
                                        h = packet.getInt();
                                        i = 0;
                                        while (true) {
                                            if (i >= h) break;
                                            hdr = packet.getHeader();
                                            val = packet.getString();
                                            request.setField(hdr, val);
                                            if (!this._keepAlive && hdr.equalsIgnoreCase("Connection") && val.equalsIgnoreCase("keep-alive")) {
                                                this._keepAlive = true;
                                            }
                                            ++i;
                                        }
                                        attr = packet.getByte();
                                        while (true) {
                                            if ((255 & attr) == 255) {
                                                this._listener.customizeRequest(this, request);
                                                gotRequest = true;
                                                this.statsRequestStart();
                                                request.setState(2);
                                                if (request.getContentLength() == 0 && request.getField("Transfer-Encoding") == null) {
                                                    this._ajpIn.close();
                                                }
                                                response.setState(0);
                                                response.setVersion("HTTP/1.1");
                                                response.setDateField("Date", this._request.getTimeStamp());
                                                response.setField("Server", Version.__VersionDetail);
                                                Code.debug((Object)"REQUEST:\n", (Object)request);
                                                context = this.service(request, response);
                                                Code.debug((Object)"RESPONSE:\n", (Object)response);
                                            }
                                            value = packet.getString();
                                            switch (attr) {
                                                case 10: {
                                                    request.setAttribute(value, packet.getString());
                                                    break;
                                                }
                                                case 9: {
                                                    break;
                                                }
                                                case 8: {
                                                    request.setAttribute("javax.servlet.request.cipher_suite", value);
                                                    break;
                                                }
                                                case 7: {
                                                    cf = CertificateFactory.getInstance("X.509");
                                                    certstream = new ByteArrayInputStream(value.getBytes());
                                                    cert = (X509Certificate)cf.generateCertificate(certstream);
                                                    certs = new X509Certificate[]{cert};
                                                    request.setAttribute("javax.servlet.request.X509Certificate", certs);
                                                    break;
                                                }
                                                case 6: {
                                                    request.setAttribute("org.mortbay.http.ajp.JVMRoute", value);
                                                    break;
                                                }
                                                case 5: {
                                                    request.setQuery(value);
                                                    break;
                                                }
                                                case 4: {
                                                    request.setAuthType(value);
                                                    break;
                                                }
                                                case 3: {
                                                    request.setAuthUser(value);
                                                    break;
                                                }
                                                default: {
                                                    Code.warning("Unknown attr: " + attr + "=" + value);
                                                }
                                            }
                                            attr = packet.getByte();
                                        }
                                    }
                                    default: {
                                        Code.debug("Ignored: " + packet);
                                        this._persistent = false;
                                    }
                                }
                                var16_13 = null;
                                if (packet == null) return false;
                                if (!gotRequest) {
                                    return false;
                                }
                                ** try [egrp 4[TRYBLOCK] [6 : 782->870)] { 
lbl155:
                                // 1 sources

                                ** try [egrp 5[TRYBLOCK] [5 : 782->846)] { 
lbl156:
                                // 1 sources

                                this.getOutputStream().close();
                                if (!this._persistent) {
                                    this._ajpOut.end();
                                }
                                this._ajpOut.close();
                                this.getOutputStream().resetStream();
                                this.getOutputStream().addObserver(this);
                                this.getInputStream().resetStream();
                                this._ajpIn.resetStream();
                                this._ajpOut.resetStream();
                                v1 = null;
lbl167:
                                // 1 sources

                                catch (Exception e) {
                                    Code.debug(e);
                                    this._persistent = false;
                                    v1 = null;
                                }
                                break block64;
lbl172:
                                // 1 sources

                                catch (Throwable var18_27) {
                                    v1 = null;
                                }
                            }
                            var19_34 = v1;
                            this.statsRequestEnd();
                            if (context == null) return this._persistent;
                            context.log(request, response, -1);
                            return this._persistent;
                            catch (SocketException e) {
                                block65: {
                                    Code.ignore(e);
                                    this._persistent = false;
                                    var16_14 = null;
                                    if (packet == null) return false;
                                    if (!gotRequest) {
                                        return false;
                                    }
                                    ** try [egrp 4[TRYBLOCK] [6 : 782->870)] { 
lbl189:
                                    // 1 sources

                                    ** try [egrp 5[TRYBLOCK] [5 : 782->846)] { 
lbl190:
                                    // 1 sources

                                    this.getOutputStream().close();
                                    if (!this._persistent) {
                                        this._ajpOut.end();
                                    }
                                    this._ajpOut.close();
                                    this.getOutputStream().resetStream();
                                    this.getOutputStream().addObserver(this);
                                    this.getInputStream().resetStream();
                                    this._ajpIn.resetStream();
                                    this._ajpOut.resetStream();
                                    v2 = null;
lbl201:
                                    // 1 sources

                                    catch (Exception e) {
                                        Code.debug(e);
                                        this._persistent = false;
                                        v2 = null;
                                    }
                                    break block65;
lbl206:
                                    // 1 sources

                                    catch (Throwable var18_28) {
                                        v2 = null;
                                    }
                                }
                                var19_35 = v2;
                                this.statsRequestEnd();
                                if (context == null) return this._persistent;
                                context.log(request, response, -1);
                                return this._persistent;
                            }
                            catch (Exception e) {
                                block66: {
                                    Code.warning(e);
                                    this._persistent = false;
                                    try {
                                        if (gotRequest) {
                                            this._ajpOut.close();
                                        }
                                    }
                                    catch (IOException e2) {
                                        Code.ignore(e2);
                                    }
                                    var16_15 = null;
                                    if (packet == null) return false;
                                    if (!gotRequest) {
                                        return false;
                                    }
                                    ** try [egrp 4[TRYBLOCK] [6 : 782->870)] { 
lbl229:
                                    // 1 sources

                                    ** try [egrp 5[TRYBLOCK] [5 : 782->846)] { 
lbl230:
                                    // 1 sources

                                    this.getOutputStream().close();
                                    if (!this._persistent) {
                                        this._ajpOut.end();
                                    }
                                    this._ajpOut.close();
                                    this.getOutputStream().resetStream();
                                    this.getOutputStream().addObserver(this);
                                    this.getInputStream().resetStream();
                                    this._ajpIn.resetStream();
                                    this._ajpOut.resetStream();
                                    v3 = null;
lbl241:
                                    // 1 sources

                                    catch (Exception e) {
                                        Code.debug(e);
                                        this._persistent = false;
                                        v3 = null;
                                    }
                                    break block66;
lbl246:
                                    // 1 sources

                                    catch (Throwable var18_29) {
                                        v3 = null;
                                    }
                                }
                                var19_36 = v3;
                                this.statsRequestEnd();
                                if (context == null) return this._persistent;
                                context.log(request, response, -1);
                                return this._persistent;
                            }
                        }
                        catch (Throwable var15_51) {
                            block67: {
                                var16_16 = null;
                                if (packet == null) return false;
                                if (!gotRequest) {
                                    return false;
                                }
                                ** try [egrp 4[TRYBLOCK] [6 : 782->870)] { 
lbl261:
                                // 1 sources

                                ** try [egrp 5[TRYBLOCK] [5 : 782->846)] { 
lbl262:
                                // 1 sources

                                this.getOutputStream().close();
                                if (!this._persistent) {
                                    this._ajpOut.end();
                                }
                                this._ajpOut.close();
                                this.getOutputStream().resetStream();
                                this.getOutputStream().addObserver(this);
                                this.getInputStream().resetStream();
                                this._ajpIn.resetStream();
                                this._ajpOut.resetStream();
                                v4 = null;
lbl273:
                                // 1 sources

                                catch (Exception e) {
                                    Code.debug(e);
                                    this._persistent = false;
                                    v4 = null;
                                }
                                break block67;
lbl278:
                                // 1 sources

                                catch (Throwable var18_30) {
                                    v4 = null;
                                }
                            }
                            var19_37 = v4;
                            this.statsRequestEnd();
                            if (context == null) throw var15_51;
                            context.log(request, response, -1);
                            throw var15_51;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [6 : 782->870)] { 
lbl288:
                    // 1 sources

                    ** try [egrp 5[TRYBLOCK] [5 : 782->846)] { 
lbl289:
                    // 1 sources

                    this.getOutputStream().close();
                    if (!this._persistent) {
                        this._ajpOut.end();
                    }
                    this._ajpOut.close();
                    this.getOutputStream().resetStream();
                    this.getOutputStream().addObserver(this);
                    this.getInputStream().resetStream();
                    this._ajpIn.resetStream();
                    this._ajpOut.resetStream();
                    v5 = null;
lbl300:
                    // 1 sources

                    catch (Exception e) {
                        Code.debug(e);
                        this._persistent = false;
                        v5 = null;
                    }
                    break block68;
lbl305:
                    // 1 sources

                    catch (Throwable var18_24) {
                        v5 = null;
                    }
                }
                var19_31 = v5;
                this.statsRequestEnd();
                if (context == null) return var6_6;
                context.log(request, response, -1);
                return var6_6;
            }
            var16_11 = null;
            if (packet == null) return false;
            if (!gotRequest) {
                return false;
            }
            ** try [egrp 4[TRYBLOCK] [6 : 782->870)] { 
lbl319:
            // 1 sources

            ** try [egrp 5[TRYBLOCK] [5 : 782->846)] { 
lbl320:
            // 1 sources

            this.getOutputStream().close();
            if (!this._persistent) {
                this._ajpOut.end();
            }
            this._ajpOut.close();
            this.getOutputStream().resetStream();
            this.getOutputStream().addObserver(this);
            this.getInputStream().resetStream();
            this._ajpIn.resetStream();
            this._ajpOut.resetStream();
            v6 = null;
lbl331:
            // 1 sources

            catch (Exception e) {
                Code.debug(e);
                this._persistent = false;
                v6 = null;
            }
            break block69;
lbl336:
            // 1 sources

            catch (Throwable var18_25) {
                v6 = null;
            }
        }
        var19_32 = v6;
        this.statsRequestEnd();
        if (context == null) return var7_38;
        context.log(request, response, -1);
        return var7_38;
    }

    protected void firstWrite() throws IOException {
        Code.debug("ajp13 firstWrite()");
    }

    protected void commit() throws IOException {
        Code.debug("ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

