/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

public class BlockingQueue {
    Object[] elements;
    Object lock;
    int maxSize;
    int size = 0;
    int head = 0;
    int tail = 0;

    public BlockingQueue(int maxSize) {
        this(null, maxSize);
    }

    public BlockingQueue(Object lock, int maxSize) {
        this.maxSize = maxSize;
        if (maxSize == 0) {
            this.maxSize = 255;
        }
        this.elements = new Object[this.maxSize];
        this.lock = lock == null ? this.elements : lock;
    }

    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.size = 0;
            this.head = 0;
            this.tail = 0;
        }
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public void put(Object o) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == this.maxSize) {
                this.lock.wait();
            }
            this.elements[this.tail] = o;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.lock.notify();
        }
    }

    public void put(Object o, int timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == this.maxSize) {
                this.lock.wait(timeout);
                if (this.size == this.maxSize) {
                    throw new InterruptedException("Timed out");
                }
            }
            this.elements[this.tail] = o;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.lock.notify();
        }
    }

    public Object get() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == 0) {
                this.lock.wait();
            }
            Object o = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.lock.notifyAll();
            }
            --this.size;
            Object object2 = o;
            return object2;
        }
    }

    public Object get(int timeoutMs) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == 0 && timeoutMs != 0) {
                this.lock.wait(timeoutMs);
            }
            if (this.size == 0) {
                Object var3_3 = null;
                return var3_3;
            }
            Object o = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.lock.notifyAll();
            }
            --this.size;
            Object object2 = o;
            return object2;
        }
    }

    public Object peek() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            Object o;
            if (this.size == 0) {
                this.lock.wait();
            }
            if (this.size == 0) {
                Object var2_2 = null;
                return var2_2;
            }
            Object object2 = o = this.elements[this.head];
            return object2;
        }
    }

    public Object peek(int timeoutMs) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            Object o;
            if (this.size == 0) {
                this.lock.wait(timeoutMs);
            }
            if (this.size == 0) {
                Object var3_3 = null;
                return var3_3;
            }
            Object object2 = o = this.elements[this.head];
            return object2;
        }
    }
}

